/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.aksw.commons.util.StreamUtils;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.file.CacheEntryFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class CacheBackendFile
implements CacheBackend {
    private File parentFile;
    private long lifespan;

    public CacheBackendFile(File parentFile, long lifespan) {
        boolean canWrite;
        this.parentFile = parentFile;
        this.lifespan = lifespan;
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!(canWrite = parentFile.canWrite())) {
            throw new RuntimeException("Cache cannot write to: " + parentFile.getAbsolutePath());
        }
    }

    @Override
    public CacheEntry lookup(String service, String queryString) {
        String fileName = StringUtils.urlEncode((String)service) + "-" + StringUtils.md5Hash((String)queryString) + ".dat.bz2";
        File file = new File(this.parentFile, fileName);
        CacheEntryFile result = file.exists() ? new CacheEntryFile(file, this.lifespan) : null;
        return result;
    }

    @Override
    public void write(String service, String queryString, InputStream in) {
        String fileName = StringUtils.urlEncode((String)service) + "-" + StringUtils.md5Hash((String)queryString) + ".dat.bz2";
        File file = new File(this.parentFile, fileName);
        if (file.exists()) {
            file.delete();
        }
        String tmpFileName = fileName + ".tmp";
        File tmpFile = new File(this.parentFile, tmpFileName);
        try {
            if (!tmpFile.exists()) {
                tmpFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(tmpFile);
            BZip2CompressorOutputStream out = new BZip2CompressorOutputStream((OutputStream)fos);
            StreamUtils.copyThenClose((InputStream)in, (OutputStream)out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        tmpFile.renameTo(file);
    }
}

