/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.aksw.commons.util.compress.MetaBZip2CompressorInputStream;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;

public class CacheEntryFile
implements CacheEntry {
    private File file;
    private long lifespan;

    public CacheEntryFile(File file, long lifespan) {
        this.file = file;
        this.lifespan = lifespan;
    }

    @Override
    public long getTimestamp() {
        long result = this.file.lastModified();
        return result;
    }

    @Override
    public long getLifespan() {
        return this.lifespan;
    }

    @Override
    public InputStream getInputStream() {
        MetaBZip2CompressorInputStream result;
        try {
            FileInputStream in = new FileInputStream(this.file);
            result = new MetaBZip2CompressorInputStream((InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

