/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.extra.SqlUtils;
import org.aksw.jena_sparql_api.cache.staging.CacheBackendDao;

public class CacheBackendDataSource
implements CacheBackend {
    private DataSource dataSource;
    private CacheBackendDao dao;
    private Map<String, ReentrantReadWriteLock> activeQueries = new HashMap<String, ReentrantReadWriteLock>();

    public CacheBackendDataSource(DataSource dataSource, CacheBackendDao dao) {
        this.dataSource = dataSource;
        this.dao = dao;
    }

    private void releaseLock(String key) {
        ReentrantReadWriteLock obj = this.activeQueries.get(key);
        if (obj.getReadHoldCount() == 0 && obj.getWriteHoldCount() == 0) {
            this.activeQueries.remove(obj);
        }
    }

    private ReentrantReadWriteLock acquireLock(String key) {
        ReentrantReadWriteLock rwLock = this.activeQueries.get(key);
        if (rwLock == null) {
            rwLock = new ReentrantReadWriteLock();
            this.activeQueries.put(key, rwLock);
        }
        return rwLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry lookup(String service, String queryString) {
        ReentrantReadWriteLock obj;
        String key = service + queryString;
        Map<String, ReentrantReadWriteLock> map = this.activeQueries;
        synchronized (map) {
            obj = this.acquireLock(key);
            obj.readLock().lock();
        }
        try {
            CacheEntry result;
            Connection conn = null;
            try {
                conn = this.dataSource.getConnection();
                result = this.dao.lookup(conn, service, queryString, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            CacheEntry cacheEntry = result;
            return cacheEntry;
        }
        finally {
            obj.readLock().unlock();
            this.releaseLock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String service, String queryString, InputStream in) {
        block13: {
            String key = service + queryString;
            ReentrantReadWriteLock rwLock = null;
            boolean isOngoingWrite = false;
            Map<String, ReentrantReadWriteLock> map = this.activeQueries;
            synchronized (map) {
                rwLock = this.acquireLock(key);
                isOngoingWrite = rwLock.writeLock().isHeldByCurrentThread();
            }
            rwLock.writeLock().lock();
            Connection conn = null;
            try {
                if (isOngoingWrite) break block13;
                conn = this.dataSource.getConnection();
                conn.setAutoCommit(false);
                try {
                    this.dao.write(conn, service, queryString, in);
                }
                catch (Exception f) {
                    conn.rollback();
                    throw f;
                }
                finally {
                    conn.commit();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                SqlUtils.close(conn);
                rwLock.writeLock().unlock();
            }
        }
    }
}

