/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.aksw.jena_sparql_api.cache.extra.CacheBackend;
import org.aksw.jena_sparql_api.cache.extra.CacheEntry;
import org.aksw.jena_sparql_api.cache.extra.CacheEntryImpl;
import org.apache.commons.io.IOUtils;

public class CacheBackendMem
implements CacheBackend {
    private Cache<String, byte[]> hashToCache;

    public CacheBackendMem() {
        this((Cache<String, byte[]>)CacheBuilder.newBuilder().build());
    }

    public CacheBackendMem(Cache<String, byte[]> hashToCache) {
        this.hashToCache = hashToCache;
    }

    @Override
    public CacheEntry lookup(String service, String queryString) {
        CacheEntryImpl result;
        String key = service + "-" + queryString;
        byte[] data = (byte[])this.hashToCache.getIfPresent((Object)key);
        if (data == null) {
            result = null;
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            result = new CacheEntryImpl(System.currentTimeMillis(), 1000L, in, queryString, key);
        }
        return result;
    }

    @Override
    public void write(String service, String queryString, InputStream in) {
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)in);
            this.hashToCache.put((Object)(service + "-" + queryString), (Object)bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

