/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.cache.staging;

import java.io.IOException;
import org.aksw.jena_sparql_api.cache.core.ModelProvider;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.cache.extra.CacheResource;
import org.aksw.jena_sparql_api.core.QueryExecutionDecorator;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCacheFrontend
extends QueryExecutionDecorator {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCacheFrontend.class);
    private CacheFrontend cacheFrontend;
    private String service;
    private String queryString;
    private CacheResource resource;

    public QueryExecutionCacheFrontend(QueryExecution decoratee, String service, String queryString, CacheFrontend cacheFrontend) {
        super(decoratee);
        this.service = service;
        this.queryString = queryString;
        this.cacheFrontend = cacheFrontend;
    }

    private void setResource(CacheResource resource) {
        if (this.resource != null) {
            this.resource.close();
            if (resource != null) {
                resource.close();
            }
        }
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet doCacheResultSet() {
        QueryExecutionCacheFrontend queryExecutionCacheFrontend = this;
        synchronized (queryExecutionCacheFrontend) {
            this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
            this.setResource(this.resource);
        }
        if (this.resource == null || this.resource.isOutdated()) {
            ResultSet rs;
            if (this.resource != null) {
                this.resource.close();
            }
            try {
                rs = this.getDecoratee().execSelect();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cacheFrontend.write(this.service, this.queryString, rs);
            QueryExecutionCacheFrontend queryExecutionCacheFrontend2 = this;
            synchronized (queryExecutionCacheFrontend2) {
                this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
                this.setResource(this.resource);
            }
            if (this.resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return this.resource.asResultSet();
    }

    public synchronized Model doCacheModel(Model result, ModelProvider modelProvider) {
        try {
            return this._doCacheModel(result, modelProvider);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Model _doCacheModel(Model result, ModelProvider modelProvider) throws IOException {
        QueryExecutionCacheFrontend queryExecutionCacheFrontend = this;
        synchronized (queryExecutionCacheFrontend) {
            this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
            this.setResource(this.resource);
        }
        if (this.resource == null || this.resource.isOutdated()) {
            Model model;
            try {
                model = modelProvider.getModel();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cacheFrontend.write(this.service, this.queryString, model);
            QueryExecutionCacheFrontend queryExecutionCacheFrontend2 = this;
            synchronized (queryExecutionCacheFrontend2) {
                this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
                this.setResource(this.resource);
            }
            if (this.resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return this.resource.asModel(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean doCacheBoolean() {
        QueryExecutionCacheFrontend queryExecutionCacheFrontend = this;
        synchronized (queryExecutionCacheFrontend) {
            this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
            this.setResource(this.resource);
        }
        if (this.resource == null || this.resource.isOutdated()) {
            boolean ret;
            try {
                ret = this.getDecoratee().execAsk();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Cache write [" + this.service + "]: " + this.queryString);
            this.cacheFrontend.write(this.service, this.queryString, ret);
            QueryExecutionCacheFrontend queryExecutionCacheFrontend2 = this;
            synchronized (queryExecutionCacheFrontend2) {
                this.resource = this.cacheFrontend.lookup(this.service, this.queryString);
                this.setResource(this.resource);
            }
            if (this.resource == null) {
                throw new RuntimeException("Cache error: Lookup of just written data failed");
            }
        } else {
            logger.trace("Cache hit [" + this.service + "]:" + this.queryString);
        }
        return this.resource.asBoolean();
    }

    @Override
    public ResultSet execSelect() {
        return this.doCacheResultSet();
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCacheFrontend.this.getDecoratee().execConstruct();
            }
        });
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        return this.doCacheModel(model, new ModelProvider(){

            @Override
            public Model getModel() {
                return QueryExecutionCacheFrontend.this.getDecoratee().execDescribe();
            }
        });
    }

    @Override
    public boolean execAsk() {
        return this.doCacheBoolean();
    }

    @Override
    public void abort() {
        if (this.resource != null) {
            this.resource.close();
        }
        super.abort();
    }
}

