/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.changeset;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.changeset.CS;
import org.aksw.jena_sparql_api.changeset.ChangeSet;
import org.aksw.jena_sparql_api.changeset.ChangeSetMetadata;
import org.aksw.jena_sparql_api.changeset.FN_TripleToMd5;
import org.aksw.jena_sparql_api.changeset.FunctionResultSetPartFirstRow;
import org.aksw.jena_sparql_api.changeset.ResourceUtils;
import org.aksw.jena_sparql_api.changeset.V;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceReference;
import org.aksw.jena_sparql_api.core.utils.UpdateRequestUtils;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceSparqlQuery;
import org.aksw.jena_sparql_api.lookup.LookupServiceTransformValue;
import org.aksw.jena_sparql_api.mapper.BindingMapperProjectVar;
import org.aksw.jena_sparql_api.mapper.FunctionBindingMapper;
import org.aksw.jena_sparql_api.update.DiffQuadUtils;
import org.aksw.jena_sparql_api.utils.GraphUtils;
import org.aksw.jena_sparql_api.utils.NodeUtils;
import org.aksw.jena_sparql_api.utils.QueryUtils;
import org.aksw.jena_sparql_api.utils.SetGraph;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class ChangeSetUtils {
    public static final Query queryMostRecentChangeSet = QueryFactory.parse((Query)new Query(), (String)"Prefix cs: <http://purl.org/vocab/changeset/schema#> Select ?s ?o ?y ?z { ?s cs:subjectOfChange ?o . Optional { ?x cs:precedingChangeSet ?s } . Optional { ?s cs:service ?y } . Optional { ?s cs:graph ?z } .  Filter(!Bound(?x)) }", (String)"http://example.org/", (Syntax)Syntax.syntaxARQ);

    public static String createHash(SparqlServiceReference serviceRef) {
        String result = serviceRef.getServiceURL() + serviceRef.getDefaultGraphURIs() + serviceRef.getNamedGraphURIs();
        result = StringUtils.md5Hash((String)result);
        return result;
    }

    public static void writeServiceReference(SparqlServiceReference serviceRef, String targetGraph, Resource root, Model model) throws IllegalAccessException {
        Resource dgs = ResourceUtils.createSubResource(root, "defaultGraphs");
        Resource ngs = ResourceUtils.createSubResource(root, "namedGraphs");
        model.add(root, RDF.type, (RDFNode)V.RdfDataset);
        model.add(root, V.endpoint, (RDFNode)model.createResource(serviceRef.getServiceURL()));
        model.add(root, V.target, (RDFNode)model.createResource(targetGraph));
        UsernamePasswordCredentials credentials = serviceRef.getCredentials();
        if (credentials != null) {
            model.add(root, V.username, (RDFNode)model.createLiteral(credentials.getUserName()));
            model.add(root, V.password, (RDFNode)model.createLiteral(credentials.getPassword()));
        }
    }

    public static LookupService<Node, Node> createLookupServiceMostRecentChangeSet(QueryExecutionFactory qef, Node service, Node graph) {
        Query query = queryMostRecentChangeSet;
        if (service != null || graph != null) {
            query = query.cloneQuery();
        }
        if (service != null) {
            QueryUtils.injectFilter((Query)query, (Expr)new E_Equals((Expr)new ExprVar(Vars.y), (Expr)NodeValue.makeNode((Node)service)));
        }
        if (graph != null) {
            QueryUtils.injectFilter((Query)query, (Expr)new E_Equals((Expr)new ExprVar(Vars.z), (Expr)NodeValue.makeNode((Node)graph)));
        }
        LookupServiceSparqlQuery ls = new LookupServiceSparqlQuery(qef, query, Vars.o);
        LookupServiceTransformValue result = LookupServiceTransformValue.create(ls, Functions.compose(FunctionBindingMapper.create(BindingMapperProjectVar.create(Vars.s)), (Function)FunctionResultSetPartFirstRow.fn));
        return result;
    }

    public static boolean isValid(ChangeSet cs) {
        String str = cs.getSubjectOfChange();
        Node s = NodeFactory.createURI((String)str);
        boolean isValidAdded = ChangeSetUtils.isSubjectOfAllTriples(s, cs.getAddition());
        boolean isValidRemoved = ChangeSetUtils.isSubjectOfAllTriples(s, cs.getAddition());
        boolean result = isValidAdded && isValidRemoved;
        return result;
    }

    public static boolean isSubjectOfTriple(Node s, Triple triple) {
        boolean result = triple.getSubject().equals((Object)s);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSubjectOfAllTriples(Node s, Graph g) {
        boolean result = true;
        try (ExtendedIterator it = g.find(Node.ANY, Node.ANY, Node.ANY);){
            while (it.hasNext()) {
                Triple triple = (Triple)it.next();
                boolean isValid = ChangeSetUtils.isSubjectOfTriple(s, triple);
                if (isValid) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static void writeLangMap(Model model, Resource s, Property p, Map<String, String> langToText) {
        if (langToText != null) {
            for (Map.Entry<String, String> entry : langToText.entrySet()) {
                String lang = entry.getKey();
                String text = entry.getValue();
                Literal o = lang == null || lang.trim().isEmpty() ? model.createLiteral(text) : model.createLiteral(text, lang);
                model.add(s, p, (RDFNode)o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeReifiedGraph(Model model, Graph graph, Function<Triple, Node> tripleToSubject) {
        try (ExtendedIterator it = graph.find(Node.ANY, Node.ANY, Node.ANY);){
            while (it.hasNext()) {
                Triple triple = (Triple)it.next();
                Node s = (Node)tripleToSubject.apply((Object)triple);
                ChangeSetUtils.writeReifiedTriple(model, s, triple);
            }
        }
    }

    public static void writeReifiedTriple(Model model, Node s, Triple triple) {
        RDFNode tmp = ModelUtils.convertGraphNodeToRDFNode((Node)s, (Model)model);
        Resource n = tmp.asResource();
        Statement stmt = ModelUtils.tripleToStatement((Model)model, (Triple)triple);
        ChangeSetUtils.writeReifiedStatement(model, n, stmt);
    }

    public static void writeReifiedStatement(Model model, Resource s, Statement stmt) {
        model.add(s, RDF.type, (RDFNode)RDF.Statement);
        model.add(s, RDF.subject, (RDFNode)stmt.getSubject());
        model.add(s, RDF.predicate, (RDFNode)stmt.getPredicate());
        model.add(s, RDF.object, stmt.getObject());
    }

    public static void add(Model model, Resource s, Property p, RDFNode o) {
        if (s != null && p != null && o != null) {
            model.add(s, p, o);
        }
    }

    public static void write(Model model, ChangeSet cs) {
        Statement stmt;
        Resource o;
        String uri;
        Resource s = model.createResource(cs.getUri());
        model.add(s, RDF.type, (RDFNode)CS.ChangeSet);
        ChangeSetMetadata md = cs.getMetadata();
        model.add(s, CS.changeReason, (RDFNode)model.createLiteral(md.getChangeReason()));
        model.add(s, CS.createdDate, (RDFNode)model.createTypedLiteral(md.getCreatedDate()));
        model.add(s, CS.creatorName, (RDFNode)model.createLiteral(md.getCreatorName()));
        model.add(s, CS.subjectOfChange, (RDFNode)model.createResource(cs.getSubjectOfChange()));
        if (cs.getService() != null) {
            model.add(s, CS.service, (RDFNode)model.createResource(cs.getService()));
        }
        if (cs.getGraph() != null) {
            model.add(s, CS.graph, (RDFNode)model.createResource(cs.getGraph()));
        }
        if (cs.getPrecedingChangeSet() != null) {
            model.add(s, CS.precedingChangeSet, (RDFNode)model.createResource(cs.getPrecedingChangeSet()));
        }
        String prefix = "http://example.org/";
        for (Triple triple : SetGraph.wrap((Graph)cs.getAddition())) {
            uri = prefix + FN_TripleToMd5.fn.apply(triple);
            o = ResourceFactory.createResource((String)uri);
            stmt = ModelUtils.tripleToStatement((Model)model, (Triple)triple);
            ChangeSetUtils.writeReifiedStatement(model, o, stmt);
            model.add(s, CS.addition, (RDFNode)o);
            model.add(s, CS.statement, (RDFNode)o);
        }
        for (Triple triple : SetGraph.wrap((Graph)cs.getRemoval())) {
            uri = prefix + FN_TripleToMd5.fn.apply(triple);
            o = ResourceFactory.createResource((String)uri);
            stmt = ModelUtils.tripleToStatement((Model)model, (Triple)triple);
            ChangeSetUtils.writeReifiedStatement(model, o, stmt);
            model.add(s, CS.removal, (RDFNode)o);
            model.add(s, CS.statement, (RDFNode)o);
        }
    }

    public static UpdateRequest createUpdateRequest(ChangeSetMetadata metadata, QueryExecutionFactory qef, Diff<? extends Iterable<Quad>> quadDiff, String prefix) {
        Map<Node, Diff<Set<Triple>>> diff = DiffQuadUtils.partitionQuads(quadDiff);
        throw new UnsupportedOperationException();
    }

    public static UpdateRequest createUpdateRequestGraph(ChangeSetMetadata metadata, QueryExecutionFactory qef, Diff<Set<Triple>> diff, String prefix, String serviceUri, String graphUri) {
        Map<Node, ChangeSet> subjectToChangeSet = ChangeSetUtils.createChangeSets(qef, serviceUri, graphUri, metadata, diff, prefix);
        Model model = ModelFactory.createDefaultModel();
        for (ChangeSet cs : subjectToChangeSet.values()) {
            ChangeSetUtils.write(model, cs);
            System.out.println("v ===================");
            model.write((OutputStream)System.out, "TURTLE");
            System.out.println("^ -------------------");
        }
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest(model, null);
        return result;
    }

    public static Map<Node, ChangeSet> createChangeSets(QueryExecutionFactory qef, String serviceUri, String graphUri, ChangeSetMetadata metadata, Diff<Set<Triple>> diff, String prefix) {
        Node service = NodeUtils.asNullableNode((String)serviceUri);
        Node graph = NodeUtils.asNullableNode((String)graphUri);
        LookupService<Node, Node> precedingChangeSetLs = ChangeSetUtils.createLookupServiceMostRecentChangeSet(qef, service, graph);
        Set added = (Set)diff.getAdded();
        Set removed = (Set)diff.getRemoved();
        Map subjectToAdded = GraphUtils.indexBySubject((Iterable)added);
        Map subjectToRemoved = GraphUtils.indexBySubject((Iterable)removed);
        HashSet subjects = new HashSet();
        subjects.addAll(subjectToAdded.keySet());
        subjects.addAll(subjectToRemoved.keySet());
        Map tmp = (Map)precedingChangeSetLs.apply(subjects);
        HashMap<Node, Node> subjectToRecentChangeSet = new HashMap<Node, Node>(tmp);
        HashMap<Node, ChangeSet> result = new HashMap<Node, ChangeSet>();
        for (Node s : subjects) {
            String subjectOfChange = s.getURI();
            Node precedingId = (Node)subjectToRecentChangeSet.get(s);
            String precedingChangeSet = precedingId == null ? null : precedingId.getURI();
            String localName = StringUtils.urlEncode((String)subjectOfChange) + "-" + StringUtils.md5Hash((String)("" + precedingId));
            String uri = prefix + localName;
            Node nextId = NodeFactory.createURI((String)uri);
            subjectToRecentChangeSet.put(s, nextId);
            Graph addedGraph = (Graph)subjectToAdded.get(s);
            Graph removedGraph = (Graph)subjectToRemoved.get(s);
            addedGraph = addedGraph == null ? GraphFactory.createGraphMem() : addedGraph;
            removedGraph = removedGraph == null ? GraphFactory.createGraphMem() : removedGraph;
            ChangeSet cs = new ChangeSet(metadata, uri, precedingChangeSet, subjectOfChange, addedGraph, removedGraph, serviceUri, graphUri);
            result.put(s, cs);
        }
        return result;
    }

    public static void enrichWithSource(Model model, Node g, SparqlServiceReference ssr) {
        model.write((OutputStream)System.out, "TTL");
        Set rs = model.listSubjectsWithProperty(RDF.type, (RDFNode)CS.ChangeSet).toSet();
    }
}

