/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.changeset;

import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.changeset.ChangeSetMetadata;
import org.aksw.jena_sparql_api.changeset.ChangeSetUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class SinkChangeSetWriter
implements Sink<Diff<? extends Iterable<Quad>>> {
    private ChangeSetMetadata metadata;
    private SparqlService sparqlService;

    public SinkChangeSetWriter(ChangeSetMetadata metadata, SparqlService sparqlService) {
        this.metadata = metadata;
        this.sparqlService = sparqlService;
    }

    public void send(Diff<? extends Iterable<Quad>> diff) {
        QueryExecutionFactory qef = this.sparqlService.getQueryExecutionFactory();
        UpdateExecutionFactory uef = this.sparqlService.getUpdateExecutionFactory();
        UpdateRequest updateRequest = ChangeSetUtils.createUpdateRequest(this.metadata, qef, diff, "http://example.org/");
        UpdateProcessor updateProcessor = uef.createUpdateProcessor(updateRequest);
        updateProcessor.execute();
    }

    public void flush() {
    }

    public void close() {
    }
}

