/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.compare;

import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.commons.collections.diff.ListDiff;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.compare.QuerySolutionWithEquals;
import org.aksw.jena_sparql_api.utils.ModelDiff;
import org.aksw.jena_sparql_api.utils.ResultSetPart;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionCompare
implements QueryExecution {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionCompare.class);
    private boolean isOrdered;
    private QueryExecution a;
    private QueryExecution b;
    private Query query = null;
    private Diff<ResultSetPart> resultSetDiff = null;
    private ModelDiff modelDiff = null;
    private Diff<Boolean> askDiff = null;

    public static Multiset<QuerySolution> toMultisetQs(ResultSet rs) {
        HashMultiset result = HashMultiset.create();
        while (rs.hasNext()) {
            QuerySolution original = rs.next();
            QuerySolutionWithEquals wrapped = new QuerySolutionWithEquals(original);
            result.add((Object)wrapped);
        }
        return result;
    }

    public static Multiset<Binding> toMultiset(ResultSet rs) {
        HashMultiset result = HashMultiset.create();
        while (rs.hasNext()) {
            Binding original;
            Binding wrapped = original = rs.nextBinding();
            result.add((Object)wrapped);
        }
        return result;
    }

    public static ListDiff<Binding> compareOrdered(ResultSet a, ResultSet b) {
        ListDiff result = new ListDiff();
        Object x = null;
        Binding y = null;
        while (a.hasNext()) {
            String sy;
            if (!b.hasNext()) {
                while (a.hasNext()) {
                    ((List)result.getAdded()).add(a.nextBinding());
                }
                return result;
            }
            if (x == y || x.equals(y)) {
                x = a.nextBinding();
                y = b.nextBinding();
                continue;
            }
            String sx = x.toString();
            if (sx.compareTo(sy = y.toString()) < 0) {
                ((List)result.getRemoved()).add(x);
                x = a.nextBinding();
                continue;
            }
            ((List)result.getAdded()).add(y);
            y = b.nextBinding();
        }
        while (b.hasNext()) {
            ((List)result.getRemoved()).add(b.nextBinding());
        }
        return result;
    }

    public static ListDiff<Binding> compareUnordered(ResultSet a, ResultSet b) {
        ListDiff result = new ListDiff();
        Multiset<Binding> x = QueryExecutionCompare.toMultiset(a);
        Multiset<Binding> y = QueryExecutionCompare.toMultiset(b);
        HashMultiset common = HashMultiset.create((Iterable)Multisets.intersection(x, y));
        y.removeAll((Collection)common);
        x.removeAll((Collection)common);
        ((List)result.getAdded()).addAll(y);
        ((List)result.getRemoved()).addAll(x);
        return result;
    }

    public static ModelDiff compareModel(Model a, Model b) {
        ModelDiff result = new ModelDiff();
        ((Model)result.getAdded()).add(b);
        ((Model)result.getAdded()).remove(a);
        ((Model)result.getRemoved()).add(a);
        ((Model)result.getRemoved()).remove(b);
        return result;
    }

    public boolean isDifference() {
        if (this.resultSetDiff != null) {
            return !((ResultSetPart)this.resultSetDiff.getAdded()).getBindings().isEmpty() || !((ResultSetPart)this.resultSetDiff.getRemoved()).getBindings().isEmpty();
        }
        if (this.modelDiff != null) {
            return !((Model)this.modelDiff.getAdded()).isEmpty() || !((Model)this.modelDiff.getRemoved()).isEmpty();
        }
        if (this.askDiff != null) {
            return this.askDiff.getAdded() != this.askDiff.getRemoved();
        }
        throw new RuntimeException("Cannot retrieve difference because query was not executed.");
    }

    public QueryExecutionCompare(Query query, QueryExecution a, QueryExecution b, boolean isOrdered) {
        this.query = query;
        this.a = a;
        this.b = b;
        this.isOrdered = isOrdered;
    }

    public void setInitialBinding(QuerySolution binding) {
    }

    public Dataset getDataset() {
        return null;
    }

    public Context getContext() {
        return null;
    }

    public Query getQuery() {
        return this.query;
    }

    public ResultSet execSelect() {
        ResultSetRewindable y;
        ResultSetRewindable x;
        long timeA = -1L;
        long timeB = -1L;
        try {
            Stopwatch asw = Stopwatch.createStarted();
            ResultSet r = this.a.execSelect();
            x = ResultSetFactory.makeRewindable((ResultSet)r);
            x.reset();
            timeA = asw.stop().elapsed(TimeUnit.MILLISECONDS);
            Stopwatch bsw = Stopwatch.createStarted();
            ResultSet s = this.b.execSelect();
            y = ResultSetFactory.makeRewindable((ResultSet)s);
            y.reset();
            timeB = bsw.stop().elapsed(TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            this.resultSetDiff = Diff.create((Object)new ResultSetPart(), (Object)new ResultSetPart());
            throw new RuntimeException(e);
        }
        ListDiff<Binding> tmp = this.isOrdered ? QueryExecutionCompare.compareOrdered((ResultSet)x, (ResultSet)y) : QueryExecutionCompare.compareUnordered((ResultSet)x, (ResultSet)y);
        this.resultSetDiff = Diff.create((Object)new ResultSetPart(x.getResultVars(), (List)tmp.getAdded()), (Object)new ResultSetPart(y.getResultVars(), (List)tmp.getRemoved()));
        x.reset();
        this.logResultSet();
        String relation = timeA == timeB ? "=" : (timeA > timeB ? ">" : "<");
        logger.debug("Execution time relation: [" + timeA + " " + relation + " " + timeB + "]");
        return x;
    }

    public void log(long added, long removed) {
        boolean isEqual;
        String msg = added + "\t" + removed + "\t" + StringUtils.urlEncode((String)("" + this.query));
        boolean bl = isEqual = added == 0L && removed == 0L;
        if (isEqual) {
            logger.info("[ OK ] " + msg);
        } else {
            logger.warn("[FAIL] " + msg);
        }
    }

    public void log(ResultSetPart ra, ResultSetPart rb) {
        boolean isEqual;
        List a = ra.getBindings();
        List b = rb.getBindings();
        this.log(a.size(), b.size());
        boolean bl = isEqual = a.isEmpty() && b.isEmpty();
        if (!isEqual) {
            ResultSet rsa = ResultSetPart.toResultSet((ResultSetPart)ra);
            ResultSet rsb = ResultSetPart.toResultSet((ResultSetPart)rb);
            logger.debug("Excessive:\n" + ResultSetFormatter.asText((ResultSet)rsa));
            logger.debug("Missing:\n" + ResultSetFormatter.asText((ResultSet)rsb));
        }
    }

    public void logResultSet() {
        this.log((ResultSetPart)this.resultSetDiff.getAdded(), (ResultSetPart)this.resultSetDiff.getRemoved());
    }

    public void logModel() {
        this.log(((Model)this.modelDiff.getAdded()).size(), ((Model)this.modelDiff.getRemoved()).size());
    }

    public void logAsk() {
        boolean added = (Boolean)this.askDiff.getAdded();
        boolean removed = (Boolean)this.askDiff.getRemoved();
        String msg = added + "\t" + removed + "\t" + StringUtils.urlEncode((String)("" + this.query));
        if (added == removed) {
            logger.trace("[ OK ] " + msg);
        } else {
            logger.warn("[FAIL] " + msg);
        }
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        Model y;
        Model x;
        try {
            x = this.a.execConstruct();
            y = this.b.execConstruct();
        }
        catch (RuntimeException e) {
            this.modelDiff = new ModelDiff();
            throw e;
        }
        this.modelDiff = QueryExecutionCompare.compareModel(x, y);
        this.logModel();
        return x;
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        Model y;
        Model x;
        try {
            x = this.a.execDescribe();
            y = this.b.execDescribe();
        }
        catch (RuntimeException e) {
            this.modelDiff = new ModelDiff();
            throw e;
        }
        this.modelDiff = QueryExecutionCompare.compareModel(x, y);
        this.logModel();
        return x;
    }

    public boolean execAsk() {
        boolean y;
        boolean x;
        try {
            x = this.a.execAsk();
            y = this.b.execAsk();
        }
        catch (RuntimeException e) {
            this.askDiff = new Diff((Object)false, (Object)false, null);
            throw e;
        }
        this.askDiff = new Diff((Object)x, (Object)y, null);
        this.logAsk();
        return x;
    }

    public void abort() {
        try {
            this.a.abort();
        }
        finally {
            this.b.abort();
        }
    }

    public void close() {
        try {
            this.a.close();
        }
        finally {
            this.b.close();
        }
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
        this.a.setTimeout(timeout, timeoutUnits);
        this.b.setTimeout(timeout, timeoutUnits);
    }

    public void setTimeout(long timeout) {
        this.a.setTimeout(timeout);
        this.b.setTimeout(timeout);
    }

    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.a.setTimeout(timeout1, timeUnit1, timeout2, timeUnit2);
        this.b.setTimeout(timeout1, timeUnit1, timeout2, timeUnit2);
    }

    public void setTimeout(long timeout1, long timeout2) {
        this.a.setTimeout(timeout1, timeout2);
        this.b.setTimeout(timeout1, timeout2);
    }

    public Iterator<Triple> execConstructTriples() {
        throw new RuntimeException("Not implemented yet");
    }

    public Iterator<Triple> execDescribeTriples() {
        throw new RuntimeException("Not implemented yet");
    }

    public long getTimeout1() {
        return this.a.getTimeout1();
    }

    public long getTimeout2() {
        return this.a.getTimeout2();
    }

    public boolean isClosed() {
        return this.a.isClosed() && this.b.isClosed();
    }

    public Iterator<Quad> execConstructQuads() {
        throw new RuntimeException("Not implemented yet");
    }

    public Dataset execConstructDataset() {
        throw new RuntimeException("Not implemented yet");
    }

    public Dataset execConstructDataset(Dataset dataset) {
        throw new RuntimeException("Not implemented yet");
    }
}

