/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jena_sparql_api.stmt.SparqlPrologueParserImpl;
import org.aksw.jena_sparql_api.stmt.SparqlQueryParserImpl;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.GeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.VarUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.sdb.core.Generator;
import org.apache.jena.sdb.core.Gensym;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.lang.ParserSPARQL11;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.PatternVars;

public class Concept {
    private Element element;
    private Var var;
    public static final Concept TOP = Concept.create("", "s");
    public static final Concept BOTTOM = Concept.create("", "s");

    public static Concept parse(String str) {
        Concept result = Concept.parse(str, null);
        return result;
    }

    public static Concept parse(String str, PrefixMapping pm) {
        String[] splits = str.split("\\|", 2);
        if (splits.length != 2) {
            throw new RuntimeException("Invalid string: " + str);
        }
        String varName = splits[0].trim();
        if (varName.charAt(0) != '?') {
            throw new RuntimeException("var name must start with '?'");
        }
        varName = varName.substring(1);
        Concept result = Concept.create(splits[1], varName, pm);
        return result;
    }

    public static Concept create(String prologueStr, String varName, String elementStr) {
        SparqlQueryParserImpl queryParser = SparqlQueryParserImpl.create(Syntax.syntaxSPARQL_10);
        Concept result = Concept.create(prologueStr, varName, elementStr, queryParser);
        return result;
    }

    public static Concept create(String prologueStr, String varName, String elementStr, Function<String, Query> queryParser) {
        SparqlPrologueParserImpl prologueParser = new SparqlPrologueParserImpl(queryParser);
        Prologue prologue = (Prologue)prologueParser.apply(prologueStr);
        PrefixMapping prefixMapping = prologue.getPrefixMapping();
        Concept result = Concept.create(elementStr, varName, prefixMapping);
        return result;
    }

    public static Concept create(String elementStr, String varName) {
        Concept result = Concept.create(elementStr, varName, (PrefixMapping)null);
        return result;
    }

    public static Concept create(String elementStr, String varName, PrefixMapping prefixMapping) {
        ElementGroup group;
        List elements;
        boolean isEnclosed;
        Var var = Var.alloc((String)varName);
        String tmp = elementStr.trim();
        boolean bl = isEnclosed = tmp.startsWith("{") && tmp.endsWith("}");
        if (!isEnclosed) {
            tmp = "{" + tmp + "}";
        }
        tmp = "Select * " + tmp;
        Query query = new Query();
        query.setPrefixMapping(prefixMapping);
        ParserSPARQL11 parser = new ParserSPARQL11();
        parser.parse(query, tmp);
        Element element = query.getQueryPattern();
        if (element instanceof ElementGroup && (elements = (group = (ElementGroup)element).getElements()).size() == 1) {
            element = (Element)elements.get(0);
        }
        Concept result = new Concept(element, var);
        return result;
    }

    public boolean isSubjectConcept() {
        List triples;
        if (this.element instanceof ElementTriplesBlock && (triples = ((ElementTriplesBlock)this.element).getPattern().getList()).size() == 1) {
            boolean condition;
            Triple triple = (Triple)triples.get(0);
            boolean bl = condition = triple.getSubject().isVariable() && triple.getSubject().equals((Object)this.var) && triple.getPredicate().isVariable() && triple.getObject().isVariable();
            if (condition) {
                return true;
            }
        }
        return false;
    }

    public Concept applyNodeTransform(NodeTransform nodeTransform) {
        Var tmpVar = (Var)nodeTransform.apply((Object)this.var);
        Element e = ElementUtils.applyNodeTransform((Element)this.element, (NodeTransform)nodeTransform);
        Var v = tmpVar == null ? this.var : tmpVar;
        Concept result = new Concept(e, v);
        return result;
    }

    public Set<Var> getVarsMentioned() {
        Set result = SetUtils.asSet((Iterable)PatternVars.vars((Element)this.element));
        result.add(this.var);
        return result;
    }

    public Concept(Element element, Var var) {
        this.element = element;
        this.var = var;
    }

    public Concept(List<Element> elements, Var var) {
        ElementGroup group = new ElementGroup();
        for (Element item : elements) {
            if (item instanceof ElementTriplesBlock) {
                ElementTriplesBlock tmp = (ElementTriplesBlock)item;
                for (Triple t : tmp.getPattern()) {
                    group.addTriplePattern(t);
                }
                continue;
            }
            group.addElement(item);
        }
        this.element = group;
        this.var = var;
    }

    public Element getElement() {
        return this.element;
    }

    public List<Element> getElements() {
        return ElementUtils.toElementList((Element)this.element);
    }

    public Var getVar() {
        return this.var;
    }

    public Concept makeDistinctFrom(Concept that) {
        HashSet thisVarNames = new HashSet(VarUtils.getVarNames((Iterable)PatternVars.vars((Element)this.getElement())));
        HashSet thatVarNames = new HashSet(VarUtils.getVarNames((Iterable)PatternVars.vars((Element)that.getElement())));
        Sets.SetView commonVarNames = Sets.intersection(thisVarNames, thatVarNames);
        Sets.SetView combinedVarNames = Sets.union(thisVarNames, thatVarNames);
        GeneratorBlacklist generator = new GeneratorBlacklist((Generator)Gensym.create((String)"v"), (Collection)combinedVarNames);
        BindingHashMap binding = new BindingHashMap();
        for (String varName : commonVarNames) {
            Var oldVar = Var.alloc((String)varName);
            Var newVar = Var.alloc((String)generator.next());
            binding.add(oldVar, (Node)newVar);
        }
        Op op = Algebra.compile((Element)this.element);
        Op substOp = Substitute.substitute((Op)op, (Binding)binding);
        Query tmp = OpAsQuery.asQuery((Op)substOp);
        ElementGroup newElement = new ElementGroup();
        newElement.addElement(tmp.getQueryPattern());
        Var tmpVar = (Var)binding.get(this.var);
        Var newVar = tmpVar != null ? tmpVar : this.var;
        Concept result = new Concept((Element)newElement, newVar);
        return result;
    }

    public Query asQuery() {
        Query result = new Query();
        result.setQuerySelectType();
        result.setQueryPattern(this.element);
        result.setDistinct(true);
        result.getProjectVars().add(this.var);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.var == null ? 0 : this.var.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Concept other = (Concept)obj;
        if (this.element == null ? other.element != null : !this.element.equals((Object)other.element)) {
            return false;
        }
        return !(this.var == null ? other.var != null : !this.var.equals((Object)other.var));
    }

    public String toString() {
        return "Concept [element=" + this.element + ", var=" + this.var + "]";
    }
}

