/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.VarUtils;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggCountVar;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;

public class ConceptOps {
    public static Concept forAllIfRolePresent(Relation role, Concept filler, Generator<Var> generator) {
        Concept result;
        if (filler == Concept.TOP) {
            result = ConceptOps.exists(role, filler, generator);
        } else {
            Var sourceVar = role.getSourceVar();
            Var targetVar = role.getTargetVar();
            Var cnta = (Var)generator.next();
            Var cntb = (Var)generator.next();
            Element roleElement = role.getElement();
            ExprVar targetEv = new ExprVar(targetVar);
            Query qa = new Query();
            qa.setQuerySelectType();
            VarExprList pa = qa.getProject();
            pa.add(sourceVar);
            pa.add(cnta, (Expr)new ExprAggregator(Vars.x, (Aggregator)new AggCountVar((Expr)targetEv)));
            qa.setQueryPattern(roleElement);
            qa.addGroupBy((Node)sourceVar);
            Query qb = new Query();
            qb.setQuerySelectType();
            VarExprList pb = qb.getProject();
            pb.add(sourceVar);
            pb.add(cntb, (Expr)new ExprAggregator(Vars.y, (Aggregator)new AggCountVar((Expr)targetEv)));
            Concept aligned = ConceptOps.align(filler, role.getTargetConcept(), generator);
            Element x = ElementUtils.mergeElements((Element)roleElement, (Element)aligned.getElement());
            qb.setQueryPattern(x);
            qb.addGroupBy((Node)sourceVar);
            ElementGroup e = new ElementGroup();
            e.addElement((Element)new ElementSubQuery(qa));
            e.addElement((Element)new ElementSubQuery(qb));
            e.addElement((Element)new ElementFilter((Expr)new E_Equals((Expr)new ExprVar(cnta), (Expr)new ExprVar(cntb))));
            result = new Concept((Element)e, sourceVar);
        }
        return result;
    }

    public static Concept exists(Relation relation, Concept filler, Generator<Var> generator) {
        Concept targetConcept = relation.getTargetConcept();
        Concept aligned = ConceptOps.align(filler, targetConcept, generator);
        Element x = ElementUtils.mergeElements((Element)relation.getElement(), (Element)aligned.getElement());
        Concept result = new Concept(x, relation.getSourceVar());
        return result;
    }

    public static Concept align(Concept concept, Set<Var> vbs, Var vbJoinVar, Generator<Var> generator) {
        Set<Var> vas = concept.getVarsMentioned();
        Map varMap = VarUtils.createDistinctVarMap(vas, vbs, (boolean)true, generator);
        varMap.put(concept.getVar(), vbJoinVar);
        NodeTransformRenameMap nodeTransform = new NodeTransformRenameMap(varMap);
        Concept result = concept.applyNodeTransform((NodeTransform)nodeTransform);
        return result;
    }

    public static Concept align(Concept alignee, Concept forbiddenVars, Generator<Var> generator) {
        Set<Var> vbs = forbiddenVars.getVarsMentioned();
        Concept result = ConceptOps.align(alignee, vbs, forbiddenVars.getVar(), generator);
        return result;
    }

    public static Concept union(Stream<Concept> conceptStream) {
        Concept result = conceptStream.reduce(Concept.BOTTOM, (x, y) -> ConceptOps.union(y, x, null));
        return result;
    }

    public static Concept intersect(Stream<Concept> conceptStream) {
        Concept result = conceptStream.reduce(Concept.TOP, (x, y) -> ConceptOps.intersect(y, x, null));
        return result;
    }

    public static Concept union(Concept concept, Concept filter, Generator<Var> generator) {
        Concept result;
        if (filter != null && filter != Concept.BOTTOM) {
            Concept tmp = ConceptOps.align(concept, filter, generator);
            Element e = ElementUtils.unionElements((Element)concept.getElement(), (Element)tmp.getElement());
            result = new Concept(e, concept.getVar());
        } else {
            result = concept;
        }
        return result;
    }

    public static Concept intersect(Concept concept, Concept filter, Generator<Var> generator) {
        Concept result;
        if (filter != null) {
            Concept tmp = ConceptOps.align(filter, concept, generator);
            Element e = ElementUtils.mergeElements((Element)concept.getElement(), (Element)tmp.getElement());
            result = new Concept(e, concept.getVar());
        } else {
            result = concept;
        }
        return result;
    }
}

