/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MapUtils;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.core.utils.QueryGenerationUtils;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.ExprListUtils;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.Triples;
import org.aksw.jena_sparql_api.utils.VarExprListUtils;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.VarGeneratorImpl;
import org.aksw.jena_sparql_api.utils.VarUtils;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.PatternVars;

public class ConceptUtils {
    public static Concept listDeclaredProperties = Concept.create("?s a ?t . Filter(?t = <http://www.w3.org/1999/02/22-rdf-syntax-ns#Property> || ?t = <http://www.w3.org/2002/07/owl#ObjectProperty> || ?t = <http://www.w3.org/2002/07/owl#DataTypeProperty>)", "s");
    public static Concept listDeclaredClasses = Concept.create("?s a ?t . Filter(?t = <http://www.w3.org/2000/01/rdf-schema#Class> || ?t = <http://www.w3.org/2002/07/owl#Class>)", "s");
    public static Concept listUsedClasses = Concept.create("?s a ?t", "t");
    public static Concept listAllPredicates = Concept.create("?s ?p ?o", "p");
    public static Concept listAllGraphs = Concept.create("Graph ?g { ?s ?p ?o }", "g");

    public static Concept createFilterConcept(Collection<Node> nodes) {
        ElementFilter el = new ElementFilter((Expr)new E_OneOf((Expr)new ExprVar(Vars.s), ExprListUtils.nodesToExprs(nodes)));
        Concept result = new Concept((Element)el, Vars.s);
        return result;
    }

    public static Concept createRelatedConcept(Collection<Node> nodes, Relation relation) {
        Var sourceVar = relation.getSourceVar();
        Var targetVar = relation.getTargetVar();
        Element relationEl = relation.getElement();
        ExprVar ev = new ExprVar(sourceVar);
        ExprList el = ExprListUtils.nodesToExprs(nodes);
        ElementFilter filterEl = new ElementFilter((Expr)new E_OneOf((Expr)ev, el));
        Element resultEl = ElementUtils.mergeElements((Element)relationEl, (Element)filterEl);
        Concept result = new Concept(resultEl, targetVar);
        return result;
    }

    public static Concept getRelatedConcept(Concept source, Relation relation) {
        Concept renamedSource = ConceptUtils.createRenamedSourceConcept(source, relation);
        Element merged = ElementUtils.mergeElements((Element)renamedSource.getElement(), (Element)relation.getElement());
        Var targetVar = relation.getTargetVar();
        Concept result = new Concept(merged, targetVar);
        return result;
    }

    public static Query createQueryCount(Concept concept, Var outputVar, Long itemLimit, Long rowLimit) {
        Query subQuery = ConceptUtils.createQueryList(concept);
        if (rowLimit != null) {
            subQuery.setDistinct(false);
            subQuery.setLimit(rowLimit.longValue());
            subQuery = QueryGenerationUtils.wrapAsSubQuery(subQuery, concept.getVar());
            subQuery.setDistinct(true);
        }
        if (itemLimit != null) {
            subQuery.setLimit(itemLimit.longValue());
        }
        ElementSubQuery esq = new ElementSubQuery(subQuery);
        Query result = new Query();
        result.setQuerySelectType();
        result.getProject().add(outputVar, (Expr)new ExprAggregator(null, (Aggregator)new AggCount()));
        result.setQueryPattern((Element)esq);
        return result;
    }

    public static Set<Var> getVarsMentioned(Concept concept) {
        Collection tmp = PatternVars.vars((Element)concept.getElement());
        Set result = SetUtils.asSet((Iterable)tmp);
        return result;
    }

    public static Concept createSubjectConcept() {
        ElementTriplesBlock e = new ElementTriplesBlock();
        e.addTriple(Triples.spo);
        Concept result = new Concept((Element)e, Vars.s);
        return result;
    }

    public static Map<Var, Var> createDistinctVarMap(Set<Var> workload, Set<Var> blacklist, Generator<Var> generator) {
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create(generator, blacklist);
        HashMap<Var, Var> result = new HashMap<Var, Var>();
        for (Var var : workload) {
            boolean isBlacklisted = blacklist.contains(var);
            Var t = isBlacklisted ? (Var)generator.next() : var;
            result.put(var, t);
        }
        return result;
    }

    public static Generator<Var> createGenerator(Concept concept) {
        Collection tmp = PatternVars.vars((Element)concept.getElement());
        VarGeneratorBlacklist result = VarGeneratorBlacklist.create((String)"v", (Collection)tmp);
        return result;
    }

    public static Concept renameVar(Concept concept, Var targetVar) {
        Concept result;
        if (concept.getVar().equals((Object)targetVar)) {
            result = concept;
        } else {
            Set<Var> conceptVars = ConceptUtils.getVarsMentioned(concept);
            Map<Var, Var> varMap = ConceptUtils.createDistinctVarMap(conceptVars, Collections.singleton(targetVar), (Generator<Var>)VarGeneratorImpl.create((String)"v"));
            varMap.put(concept.getVar(), targetVar);
            Element replElement = ElementUtils.createRenamedElement((Element)concept.getElement(), varMap);
            Var replVar = varMap.get(concept.getVar());
            result = new Concept(replElement, replVar);
        }
        return result;
    }

    public static Map<Var, Var> createVarMap(Concept attrConcept, Concept filterConcept) {
        Element attrElement = attrConcept.getElement();
        Element filterElement = filterConcept.getElement();
        Collection attrVars = PatternVars.vars((Element)attrElement);
        Collection filterVars = PatternVars.vars((Element)filterElement);
        List<Var> attrJoinVars = Collections.singletonList(attrConcept.getVar());
        List<Var> filterJoinVars = Collections.singletonList(filterConcept.getVar());
        Map result = VarUtils.createJoinVarMap((Collection)attrVars, (Collection)filterVars, attrJoinVars, filterJoinVars, null);
        return result;
    }

    public static Concept createRenamedSourceConcept(Concept concept, Relation relation) {
        Concept attrConcept = new Concept(relation.getElement(), relation.getSourceVar());
        Concept result = ConceptUtils.createRenamedConcept(attrConcept, concept);
        return result;
    }

    public static Concept createRenamedConcept(Concept concept, Map<Var, Var> varMap) {
        Var newVar = (Var)MapUtils.getOrElse(varMap, (Object)concept.getVar(), (Object)concept.getVar());
        Element newElement = ElementUtils.createRenamedElement((Element)concept.getElement(), varMap);
        Concept result = new Concept(newElement, newVar);
        return result;
    }

    public static Concept createRenamedConcept(Concept attrConcept, Concept filterConcept) {
        Map<Var, Var> varMap = ConceptUtils.createVarMap(attrConcept, filterConcept);
        Var attrVar = attrConcept.getVar();
        Element filterElement = filterConcept.getElement();
        Element newFilterElement = ElementUtils.createRenamedElement((Element)filterElement, varMap);
        Concept result = new Concept(newFilterElement, attrVar);
        return result;
    }

    public static Concept createCombinedConcept(Concept attrConcept, Concept filterConcept, boolean renameVars, boolean attrsOptional, boolean filterAsSubquery) {
        Element e;
        Var attrVar = attrConcept.getVar();
        Var filterVar = filterConcept.getVar();
        if (!filterVar.equals((Object)attrVar)) {
            HashMap<Var, Var> varMap = new HashMap<Var, Var>();
            varMap.put(filterVar, attrVar);
            Var distinctAttrVar = Var.alloc((String)("cc_" + attrVar.getName()));
            varMap.put(attrVar, distinctAttrVar);
            filterConcept = ConceptUtils.createRenamedConcept(filterConcept, varMap);
        }
        Concept tmpConcept = renameVars ? ConceptUtils.createRenamedConcept(attrConcept, filterConcept) : filterConcept;
        List<Element> tmpElements = tmpConcept.getElements();
        Element attrElement = attrConcept.getElement();
        if (!tmpElements.isEmpty()) {
            if (tmpConcept.isSubjectConcept()) {
                e = attrConcept.getElement();
            } else {
                ArrayList<Element> newElements = new ArrayList<Element>();
                if (attrsOptional) {
                    attrElement = new ElementOptional(attrConcept.getElement());
                }
                newElements.add(attrElement);
                if (filterAsSubquery) {
                    tmpElements = Collections.singletonList(new ElementSubQuery(tmpConcept.asQuery()));
                }
                newElements.addAll(tmpElements);
                e = ElementUtils.createElementGroup(newElements);
            }
        } else {
            e = attrElement;
        }
        Concept result = new Concept(e, attrVar);
        return result;
    }

    public static boolean isGroupedOnlyByVar(Query query, Var groupVar) {
        Expr expr;
        boolean hasOneGroup;
        boolean result = false;
        boolean bl = hasOneGroup = query.getGroupBy().size() == 1;
        if (hasOneGroup && (expr = (Expr)query.getGroupBy().getExprs().values().iterator().next()) instanceof ExprVar) {
            Var v = expr.asVar();
            result = v.equals((Object)groupVar);
        }
        return result;
    }

    public static boolean isDistinctConceptVar(Query query, Var conceptVar) {
        boolean isDistinct = query.isDistinct();
        List projectVars = query.getProjectVars();
        boolean hasSingleVar = !query.isQueryResultStar() && projectVars != null && projectVars.size() == 1;
        boolean result = isDistinct && hasSingleVar && ((Var)projectVars.iterator().next()).equals((Object)conceptVar);
        return result;
    }

    public static boolean isConceptQuery(Query query, Var conceptVar) {
        boolean isDistinctGroupByVar = ConceptUtils.isGroupedOnlyByVar(query, conceptVar);
        boolean isDistinctConceptVar = ConceptUtils.isDistinctConceptVar(query, conceptVar);
        boolean result = isDistinctGroupByVar || isDistinctConceptVar;
        return result;
    }

    public static Query createQueryList(Concept concept) {
        Query result = ConceptUtils.createQueryList(concept, null, null);
        return result;
    }

    public static Query createQueryList(Concept concept, Long limit, Long offset) {
        Query result = new Query();
        result.setQuerySelectType();
        result.setDistinct(true);
        result.setLimit(limit == null ? Long.MIN_VALUE : limit);
        result.setOffset(offset == null ? Long.MIN_VALUE : offset);
        result.getProject().add(concept.getVar());
        Element e = concept.getElement();
        if (e instanceof ElementSubQuery) {
            e = ElementUtils.createElementGroup((Element[])new Element[]{e});
        }
        result.setQueryPattern(e);
        return result;
    }

    public static Query createAttrQuery(Query attrQuery, Var attrVar, boolean isLeftJoin, Concept filterConcept, Long limit, Long offset, boolean forceSubQuery) {
        Query result;
        Concept attrConcept = new Concept((Element)new ElementSubQuery(attrQuery), attrVar);
        Concept renamedFilterConcept = ConceptUtils.createRenamedConcept(attrConcept, filterConcept);
        boolean isAttrVarPrimaryKey = ConceptUtils.isConceptQuery(attrQuery, attrVar);
        if (isAttrVarPrimaryKey) {
            Element se;
            result = attrQuery.cloneQuery();
            if (forceSubQuery) {
                Query sq = new Query();
                sq.setQuerySelectType();
                sq.setDistinct(true);
                sq.getProject().add(attrConcept.getVar());
                sq.setQueryPattern(attrQuery.getQueryPattern());
                ElementSubQuery tmp = new ElementSubQuery(sq);
                Set refVars = VarExprListUtils.getRefVars((VarExprList)attrQuery.getProject());
                if (refVars.size() == 1 && attrVar.equals(refVars.iterator().next())) {
                    se = tmp;
                } else {
                    ElementGroup foo = new ElementGroup();
                    foo.addElement(attrQuery.getQueryPattern());
                    foo.addElement((Element)tmp);
                    se = foo;
                }
            } else {
                se = attrQuery.getQueryPattern();
            }
            if (isLeftJoin) {
                se = new ElementOptional(se);
            }
            if (!renamedFilterConcept.isSubjectConcept()) {
                ElementGroup newElement = ElementUtils.createElementGroup((Element[])new Element[]{renamedFilterConcept.getElement(), se});
                result.setQueryPattern((Element)newElement);
            }
            result.setLimit(limit.longValue());
            result.setOffset(offset.longValue());
        } else {
            Element newFilterElement;
            boolean requireSubQuery;
            boolean bl = requireSubQuery = limit != null || offset != null;
            if (requireSubQuery) {
                Concept subConcept;
                if (isLeftJoin) {
                    subConcept = renamedFilterConcept;
                } else {
                    Object subElement = renamedFilterConcept.isSubjectConcept() ? attrQuery.getQueryPattern() : ElementUtils.createElementGroup((Element[])new Element[]{attrQuery.getQueryPattern(), renamedFilterConcept.getElement()});
                    subConcept = new Concept((Element)subElement, attrVar);
                }
                Query subQuery = ConceptUtils.createQueryList(subConcept, limit, offset);
                newFilterElement = new ElementSubQuery(subQuery);
            } else {
                newFilterElement = renamedFilterConcept.getElement();
            }
            Query query = attrQuery.cloneQuery();
            Element attrElement = query.getQueryPattern();
            Object newAttrElement = !requireSubQuery && filterConcept != null && filterConcept.isSubjectConcept() ? attrElement : (isLeftJoin ? ElementUtils.createElementGroup((Element[])new Element[]{newFilterElement, new ElementOptional(attrElement)}) : ElementUtils.createElementGroup((Element[])new Element[]{attrElement, newFilterElement}));
            query.setQueryPattern(newAttrElement);
            result = query;
        }
        return result;
    }

    public static Var freshVar(Concept concept) {
        Var result = ConceptUtils.freshVar(concept, null);
        return result;
    }

    public static Var freshVar(Concept concept, String baseVarName) {
        baseVarName = baseVarName == null ? "c" : baseVarName;
        Set<Var> varsMentioned = concept.getVarsMentioned();
        Generator varGen = VarUtils.createVarGen((String)baseVarName, varsMentioned);
        Var result = (Var)varGen.next();
        return result;
    }

    public static Concept createRenamedConcept(Concept concept, Var attrVar) {
        Var newVar = ConceptUtils.freshVar(concept);
        HashMap<Var, Var> varMap = new HashMap<Var, Var>();
        varMap.put(attrVar, newVar);
        varMap.put(concept.getVar(), attrVar);
        Concept result = ConceptUtils.createRenamedConcept(concept, varMap);
        return result;
    }
}

