/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.stmt.SparqlElementParserImpl;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.VarUtils;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.PatternVars;

public class Relation {
    private Var sourceVar;
    private Var targetVar;
    private Element element;

    public Relation(Element element, Var sourceVar, Var targetVar) {
        this.element = element;
        this.sourceVar = sourceVar;
        this.targetVar = targetVar;
    }

    public Var getSourceVar() {
        return this.sourceVar;
    }

    public Var getTargetVar() {
        return this.targetVar;
    }

    public Element getElement() {
        return this.element;
    }

    public Relation reverse() {
        Relation result = new Relation(this.element, this.targetVar, this.sourceVar);
        return result;
    }

    public Concept getSourceConcept() {
        Concept result = new Concept(this.element, this.sourceVar);
        return result;
    }

    public Concept getTargetConcept() {
        Concept result = new Concept(this.element, this.targetVar);
        return result;
    }

    public static Relation create(String elementStr, String sourceVarName, String targetVarName) {
        SparqlElementParserImpl parser = SparqlElementParserImpl.create(Syntax.syntaxARQ, null);
        Relation result = Relation.create(elementStr, sourceVarName, targetVarName, parser);
        return result;
    }

    public static Relation create(String elementStr, String sourceVarName, String targetVarName, Function<String, ? extends Element> elementParser) {
        ElementGroup group;
        List elements;
        Element element;
        boolean isEnclosed;
        Var sourceVar = Var.alloc((String)sourceVarName);
        Var targetVar = Var.alloc((String)targetVarName);
        String tmp = elementStr.trim();
        boolean bl = isEnclosed = tmp.startsWith("{") && tmp.endsWith("}");
        if (!isEnclosed) {
            tmp = "{" + tmp + "}";
        }
        if ((element = elementParser.apply(tmp)) instanceof ElementGroup && (elements = (group = (ElementGroup)element).getElements()).size() == 1) {
            element = (Element)elements.get(0);
        }
        Relation result = new Relation(element, sourceVar, targetVar);
        return result;
    }

    public Set<Var> getVarsMentioned() {
        Set result = SetUtils.asSet((Iterable)PatternVars.vars((Element)this.element));
        result.add(this.sourceVar);
        result.add(this.targetVar);
        return result;
    }

    public Relation applyNodeTransform(NodeTransform nodeTransform) {
        Var s = VarUtils.applyNodeTransform((Var)this.sourceVar, (NodeTransform)nodeTransform);
        Var t = VarUtils.applyNodeTransform((Var)this.targetVar, (NodeTransform)nodeTransform);
        Element e = ElementUtils.applyNodeTransform((Element)this.element, (NodeTransform)nodeTransform);
        Relation result = new Relation(e, s, t);
        return result;
    }

    public static Relation create(Path path) {
        Relation result = new Relation((Element)ElementUtils.createElement((TriplePath)new TriplePath((Node)Vars.s, path, (Node)Vars.o)), Vars.s, Vars.o);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.sourceVar == null ? 0 : this.sourceVar.hashCode());
        result = 31 * result + (this.targetVar == null ? 0 : this.targetVar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Relation other = (Relation)obj;
        if (this.element == null ? other.element != null : !this.element.equals((Object)other.element)) {
            return false;
        }
        if (this.sourceVar == null ? other.sourceVar != null : !this.sourceVar.equals((Object)other.sourceVar)) {
            return false;
        }
        return !(this.targetVar == null ? other.targetVar != null : !this.targetVar.equals((Object)other.targetVar));
    }

    public String toString() {
        String result = this.sourceVar + " " + this.targetVar + " | " + this.element;
        return result;
    }

    public static boolean isEmpty(Relation relation) {
        boolean result;
        Element e = relation.getElement();
        if (e instanceof ElementGroup) {
            ElementGroup g = (ElementGroup)e;
            result = g.getElements().isEmpty();
        } else {
            result = false;
        }
        return result;
    }
}

