/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import java.util.Set;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggCountVar;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementSubQuery;

public class RelationOps {
    public static Relation from(Path path) {
        TriplePath tp = new TriplePath((Node)Vars.s, path, (Node)Vars.o);
        ElementPathBlock e = new ElementPathBlock();
        e.addTriplePath(tp);
        Relation result = new Relation((Element)e, Vars.s, Vars.o);
        return result;
    }

    public static Relation forAllHavingTheSameValue(Relation role, Generator<Var> baseGenerator) {
        Set<Var> blacklist = role.getVarsMentioned();
        VarGeneratorBlacklist generator = VarGeneratorBlacklist.create(baseGenerator, blacklist);
        Var cnta = (Var)generator.next();
        Var cntb = (Var)generator.next();
        Var sourceVar = role.getSourceVar();
        Var targetVar = role.getTargetVar();
        Element roleElement = role.getElement();
        ExprVar targetEv = new ExprVar(targetVar);
        Query qa = new Query();
        qa.setQuerySelectType();
        VarExprList pa = qa.getProject();
        pa.add(sourceVar);
        pa.add(cnta, (Expr)new ExprAggregator(Vars.x, (Aggregator)new AggCountVar((Expr)targetEv)));
        qa.setQueryPattern(roleElement);
        qa.addGroupBy((Node)sourceVar);
        Query qb = new Query();
        qb.setQuerySelectType();
        VarExprList pb = qb.getProject();
        pb.add(sourceVar);
        pb.add(targetVar);
        pb.add(cntb, (Expr)new ExprAggregator(Vars.y, (Aggregator)new AggCountVar((Expr)targetEv)));
        qb.setQueryPattern(role.getElement());
        qb.addGroupBy((Node)sourceVar);
        qb.addGroupBy((Node)targetVar);
        ElementGroup e = new ElementGroup();
        e.addElement((Element)new ElementSubQuery(qa));
        e.addElement((Element)new ElementSubQuery(qb));
        e.addElement((Element)new ElementFilter((Expr)new E_Equals((Expr)new ExprVar(cnta), (Expr)new ExprVar(cntb))));
        Relation result = new Relation((Element)e, sourceVar, targetVar);
        return result;
    }
}

