/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.ResultSetCloseable;
import org.aksw.jena_sparql_api.utils.CannedQueryUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

public class Describer
extends PrefetchIterator<Triple> {
    private Iterator<Node> openNodes;
    private Collection<Var> resultVars;
    private ResultSetCloseable rs;
    private Binding currentBinding = null;
    private Iterator<Var> currentVar = null;
    private QueryExecutionFactory qef;
    private QueryExecution currentQe = null;

    public Describer(Iterator<Node> openNodes, ResultSetCloseable rs, Collection<Var> resultVars, QueryExecutionFactory qef) {
        this.openNodes = openNodes;
        this.resultVars = resultVars;
        this.rs = rs;
        this.qef = qef;
    }

    public static Describer create(List<Node> resultUris, List<String> resultVars, ResultSetCloseable rs, QueryExecutionFactory qef) {
        HashSet<Var> vars = null;
        if (rs != null) {
            if (!rs.hasNext()) {
                rs = null;
                resultVars = null;
            } else {
                vars = new HashSet<Var>();
                for (String var : resultVars) {
                    vars.add(Var.alloc((String)var));
                }
            }
        }
        Iterator<Node> it = resultUris == null ? null : resultUris.iterator();
        Describer result = new Describer(it, rs, vars, qef);
        return result;
    }

    public Iterator<Triple> describeNodeStreaming(Node node) {
        Query query = CannedQueryUtils.constructBySubject((Node)node);
        QueryExecution qe = this.qef.createQueryExecution(query);
        return qe.execConstructTriples();
    }

    protected Iterator<Triple> prefetch() throws Exception {
        HashSet<Node> batch = new HashSet<Node>();
        int n = 10;
        while (this.openNodes != null && this.openNodes.hasNext() && batch.size() < n) {
            Node node = this.openNodes.next();
            batch.add(node);
        }
        while (batch.size() < n && this.rs != null) {
            Var var;
            Node node;
            if (this.currentVar == null || !this.currentVar.hasNext()) {
                if (!this.rs.hasNext()) break;
                this.currentBinding = this.rs.nextBinding();
                this.currentVar = this.resultVars.iterator();
            }
            if ((node = this.currentBinding.get(var = this.currentVar.next())) == null || !node.isURI()) continue;
            batch.add(node);
        }
        if (batch.isEmpty()) {
            this.currentQe = null;
            return null;
        }
        Query q = CannedQueryUtils.constructBySubjects(batch);
        this.currentQe = this.qef.createQueryExecution(q);
        Iterator result = this.currentQe.execConstructTriples();
        return result;
    }

    public void close() {
        block6: {
            try {
                if (this.rs == null) break block6;
                try {
                    this.rs.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (this.currentQe != null) {
                    this.currentQe.close();
                }
            }
        }
    }
}

