/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import com.google.common.base.Supplier;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.core.FluentFnBase;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDatasetDescription;
import org.aksw.jena_sparql_api.core.QueryExecutionFactorySelect;
import org.aksw.jena_sparql_api.delay.core.QueryExecutionFactoryDelay;
import org.aksw.jena_sparql_api.limit.QueryExecutionFactoryLimit;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.jena_sparql_api.parse.QueryExecutionFactoryParse;
import org.aksw.jena_sparql_api.post_process.QueryExecutionFactoryPostProcess;
import org.aksw.jena_sparql_api.prefix.core.QueryExecutionFactoryPrefix;
import org.aksw.jena_sparql_api.retry.core.QueryExecutionFactoryRetry;
import org.aksw.jena_sparql_api.transform.QueryExecutionFactoryQueryTransform;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetDescription;

public class FluentQueryExecutionFactoryFn<P>
extends FluentFnBase<QueryExecutionFactory, P> {
    public FluentQueryExecutionFactoryFn() {
        this(null, null);
    }

    public FluentQueryExecutionFactoryFn<P> compose(Function<QueryExecutionFactory, QueryExecutionFactory> nextFn) {
        super.compose(nextFn);
        return this;
    }

    public FluentQueryExecutionFactoryFn(Supplier<P> parentSupplier, Function<QueryExecutionFactory, QueryExecutionFactory> fn) {
        super(true);
        this.parentSupplier = parentSupplier;
        this.fn = fn;
    }

    public FluentQueryExecutionFactoryFn<P> withDelay(final int delayDuration, final TimeUnit delayTimeUnit) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryDelay r = new QueryExecutionFactoryDelay(qef, delayDuration, delayTimeUnit);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withPrefixes(final PrefixMapping pm, final boolean doClone) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryPrefix r = new QueryExecutionFactoryPrefix(qef, pm, doClone);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withParser(final Function<String, Query> parser) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryParse r = new QueryExecutionFactoryParse(qef, parser);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withPagination(final int pageSize) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryPaginated r = new QueryExecutionFactoryPaginated(qef, pageSize);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withRetry(final int retryCount, final long retryDelayDuration, final TimeUnit retryDelayTimeUnit) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryRetry r = new QueryExecutionFactoryRetry(qef, retryCount, retryDelayDuration, retryDelayTimeUnit);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withCache(final CacheFrontend cache) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                qef = new QueryExecutionFactoryCacheEx(qef, cache);
                QueryExecutionFactoryCacheEx r = qef;
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withDefaultLimit(final long limit, final boolean doCloneQuery) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryLimit r = new QueryExecutionFactoryLimit(qef, doCloneQuery, limit);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withQueryTransform(final Function<Query, Query> queryTransform) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryQueryTransform r = new QueryExecutionFactoryQueryTransform(qef, queryTransform);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withPostProcessor(final Consumer<QueryExecution> postProcessor) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryPostProcess r = new QueryExecutionFactoryPostProcess(qef, postProcessor);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> withDatasetDescription(final DatasetDescription datasetDescription) {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactoryDatasetDescription r = new QueryExecutionFactoryDatasetDescription(qef, datasetDescription);
                return r;
            }
        });
        return this;
    }

    public FluentQueryExecutionFactoryFn<P> selectOnly() {
        this.compose((Function)new Function<QueryExecutionFactory, QueryExecutionFactory>(){

            @Override
            public QueryExecutionFactory apply(QueryExecutionFactory qef) {
                QueryExecutionFactorySelect r = new QueryExecutionFactorySelect(qef);
                return r;
            }
        });
        return this;
    }

    public static FluentQueryExecutionFactoryFn<?> start() {
        return new FluentQueryExecutionFactoryFn();
    }
}

