/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionUtils;
import org.aksw.jena_sparql_api.core.utils.QueryGenerationUtils;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.query.Query;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphQueryExecutionFactory
extends GraphBase {
    private QueryExecutionFactory qef;
    boolean delegateClose;

    public GraphQueryExecutionFactory(QueryExecutionFactory qef) {
        this(qef, true);
    }

    public GraphQueryExecutionFactory(QueryExecutionFactory qef, boolean delegateClose) {
        this.qef = qef;
        this.delegateClose = delegateClose;
    }

    public void close() {
        if (this.delegateClose) {
            this.qef.close();
        }
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        Query query = QueryGenerationUtils.createQueryTriple(m);
        ExtendedIterator<Triple> result = QueryExecutionUtils.execConstruct(this.qef, query);
        return result;
    }
}

