/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionDecoratorBase<T extends QueryExecution>
implements QueryExecution {
    protected T decoratee;

    public QueryExecutionDecoratorBase(T decoratee) {
        this.decoratee = decoratee;
    }

    public QueryExecution getDecoratee() {
        return this.decoratee;
    }

    public void setInitialBinding(QuerySolution binding) {
        this.decoratee.setInitialBinding(binding);
    }

    public Dataset getDataset() {
        return this.decoratee.getDataset();
    }

    public Context getContext() {
        return this.decoratee.getContext();
    }

    public Query getQuery() {
        return this.decoratee.getQuery();
    }

    public void abort() {
        this.decoratee.abort();
    }

    public void close() {
        if (this.decoratee != null) {
            this.decoratee.close();
        }
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
        this.decoratee.setTimeout(timeout, timeoutUnits);
    }

    public void setTimeout(long timeout) {
        this.decoratee.setTimeout(timeout);
    }

    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.decoratee.setTimeout(timeout1, timeUnit1, timeout2, timeUnit2);
    }

    public void setTimeout(long timeout1, long timeout2) {
        this.decoratee.setTimeout(timeout1, timeout2);
    }

    public long getTimeout1() {
        return this.decoratee.getTimeout1();
    }

    public long getTimeout2() {
        return this.decoratee.getTimeout2();
    }

    public boolean isClosed() {
        return this.decoratee.isClosed();
    }

    protected void beforeExec() {
    }

    protected void afterExec() {
    }

    public ResultSet execSelect() {
        this.beforeExec();
        try {
            ResultSet resultSet = this.decoratee.execSelect();
            return resultSet;
        }
        finally {
            this.afterExec();
        }
    }

    public Model execConstruct() {
        this.beforeExec();
        try {
            Model model = this.decoratee.execConstruct();
            return model;
        }
        finally {
            this.afterExec();
        }
    }

    public Model execConstruct(Model model) {
        this.beforeExec();
        try {
            Model model2 = this.decoratee.execConstruct(model);
            return model2;
        }
        finally {
            this.afterExec();
        }
    }

    public Model execDescribe() {
        this.beforeExec();
        try {
            Model model = this.decoratee.execDescribe();
            return model;
        }
        finally {
            this.afterExec();
        }
    }

    public Model execDescribe(Model model) {
        this.beforeExec();
        try {
            Model model2 = this.decoratee.execDescribe(model);
            return model2;
        }
        finally {
            this.afterExec();
        }
    }

    public boolean execAsk() {
        this.beforeExec();
        try {
            boolean bl = this.decoratee.execAsk();
            return bl;
        }
        finally {
            this.afterExec();
        }
    }

    public Iterator<Triple> execConstructTriples() {
        this.beforeExec();
        try {
            Iterator iterator = this.decoratee.execConstructTriples();
            return iterator;
        }
        finally {
            this.afterExec();
        }
    }

    public Iterator<Triple> execDescribeTriples() {
        this.beforeExec();
        try {
            Iterator iterator = this.decoratee.execDescribeTriples();
            return iterator;
        }
        finally {
            this.afterExec();
        }
    }

    public Iterator<Quad> execConstructQuads() {
        this.beforeExec();
        try {
            Iterator iterator = this.decoratee.execConstructQuads();
            return iterator;
        }
        finally {
            this.afterExec();
        }
    }

    public Dataset execConstructDataset() {
        this.beforeExec();
        try {
            Dataset dataset = this.decoratee.execConstructDataset();
            return dataset;
        }
        finally {
            this.afterExec();
        }
    }

    public Dataset execConstructDataset(Dataset dataset) {
        this.beforeExec();
        try {
            Dataset dataset2 = this.decoratee.execConstructDataset(dataset);
            return dataset2;
        }
        finally {
            this.afterExec();
        }
    }
}

