/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBackQuery;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryExecutionBase;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionFactoryDataset
extends QueryExecutionFactoryBackQuery {
    protected Dataset dataset;
    protected Context context;

    public QueryExecutionFactoryDataset() {
        this(DatasetFactory.create());
    }

    public QueryExecutionFactoryDataset(Dataset dataset) {
        this(dataset, null);
    }

    public QueryExecutionFactoryDataset(Dataset dataset, Context context) {
        this.dataset = dataset;
        this.context = context;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public String getId() {
        return "" + this.dataset.hashCode();
    }

    @Override
    public String getState() {
        return "" + this.dataset.hashCode();
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        QueryEngineFactory f;
        query.setResultVars();
        if (this.context == null) {
            this.context = ARQ.getContext();
        }
        DatasetGraph dsg = null;
        if (this.dataset != null) {
            dsg = this.dataset.asDatasetGraph();
        }
        if ((f = QueryEngineRegistry.get().find(query, dsg, this.context)) == null) {
            Log.warn(QueryExecutionFactory.class, (String)("Failed to find a QueryEngineFactory for query: " + query));
            return null;
        }
        return new QueryExecutionBase(query, this.dataset, this.context, f);
    }

    @Override
    public void close() {
        this.dataset.close();
    }
}

