/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.aksw.jena_sparql_api.core.Time;
import org.apache.jena.query.QueryExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionTimeoutHelper {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionTimeoutHelper.class);
    private static Timer executionTimer = new Timer(true);
    private static Timer retrievalTimer = new Timer(true);
    private QueryExecution queryExecution;
    private Time maxExecutionTime = null;
    private Time maxRetrievalTime = null;
    private TimerTask executionTask = null;
    private TimerTask retrievalTask = null;

    public QueryExecutionTimeoutHelper(QueryExecution queryExecution) {
        this.queryExecution = queryExecution;
    }

    public synchronized void startExecutionTimer() {
        if (this.maxExecutionTime != null) {
            long delay = this.maxExecutionTime.getTimeUnit().toMillis(this.maxExecutionTime.getTime());
            this.executionTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        QueryExecutionTimeoutHelper.this.queryExecution.abort();
                    }
                    catch (Exception e) {
                        logger.warn("Exception while aborting a QueryExecution that has reached its execution timeout", (Throwable)e);
                    }
                }
            };
            executionTimer.schedule(this.executionTask, delay);
        }
    }

    public synchronized void stopExecutionTimer() {
        if (this.executionTask != null) {
            this.executionTask.cancel();
        }
    }

    public synchronized void startRetrieval() {
        if (this.maxRetrievalTime != null) {
            long delay = this.maxRetrievalTime.getTimeUnit().toMillis(this.maxRetrievalTime.getTime());
            this.retrievalTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        QueryExecutionTimeoutHelper.this.queryExecution.close();
                    }
                    catch (Exception e) {
                        logger.warn("Exception while closing a QueryExecution that has reached its retrieval timeout", (Throwable)e);
                    }
                }
            };
            retrievalTimer.schedule(this.retrievalTask, delay);
        }
    }

    public synchronized void stopRetrieval() {
        if (this.retrievalTask != null) {
            this.retrievalTask.cancel();
        }
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
        this.maxExecutionTime = new Time(timeout, timeoutUnits);
    }

    public void setTimeout(long timeout) {
        this.setTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.setTimeout(timeout1, timeUnit1);
        this.maxRetrievalTime = new Time(timeout2, timeUnit2);
    }

    public void setTimeout(long timeout1, long timeout2) {
        this.setTimeout(timeout1, TimeUnit.MILLISECONDS, timeout2, TimeUnit.MILLISECONDS);
    }
}

