/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.aksw.jena_sparql_api.core.ResultSetClose;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;

public class ResultSetCloseable
extends ResultSetClose {
    private Closeable closeable;
    protected List<String> resultVars;

    public ResultSetCloseable(ResultSet decoratee) {
        this(decoratee, null);
    }

    public ResultSetCloseable(ResultSet decoratee, Closeable closeable) {
        super(decoratee, true);
        this.closeable = closeable;
        this.resultVars = new ArrayList<String>(decoratee.getResultVars());
        super.checkClose();
    }

    @Override
    public List<String> getResultVars() {
        return this.resultVars;
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }

    public static ResultSetCloseable fromXml(InputStream xmlInputStream) {
        ResultSet rs = ResultSetFactory.fromXML((InputStream)xmlInputStream);
        ResultSetCloseable result = new ResultSetCloseable(rs, xmlInputStream);
        return result;
    }
}

