/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import com.google.common.base.Predicate;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.apache.http.client.HttpClient;
import org.apache.jena.sparql.core.DatasetDescription;

public class SparqlServiceFactoryDefaults
implements SparqlServiceFactory {
    protected SparqlServiceFactory delegate;
    protected String defaultServiceUri;
    protected Predicate<String> serviceUriValidator;

    public SparqlServiceFactoryDefaults(SparqlServiceFactory delegate, String defaultServiceUri, Predicate<String> serviceUriValidator) {
        this.delegate = delegate;
        this.defaultServiceUri = defaultServiceUri;
        this.serviceUriValidator = serviceUriValidator;
    }

    @Override
    public SparqlService createSparqlService(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        boolean isValidService;
        if (serviceUri == null) {
            serviceUri = this.defaultServiceUri;
        } else if (this.serviceUriValidator != null && !(isValidService = this.serviceUriValidator.apply((Object)serviceUri))) {
            throw new RuntimeException("Access to service not allowed " + serviceUri);
        }
        SparqlService result = this.delegate.createSparqlService(serviceUri, datasetDescription, httpClient);
        return result;
    }
}

