/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import java.util.HashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.cache.core.QueryExecutionFactoryCacheEx;
import org.aksw.jena_sparql_api.cache.extra.CacheFrontend;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceFactoryHttp;
import org.aksw.jena_sparql_api.core.SparqlServiceImpl;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.jena_sparql_api.utils.DatasetDescriptionUtils;
import org.apache.http.client.HttpClient;
import org.apache.jena.sparql.core.DatasetDescription;

public class SparqlServiceFactoryImpl
implements SparqlServiceFactory {
    private Map<String, SparqlService> keyToSparqlService = new HashMap<String, SparqlService>();
    private CacheFrontend cacheFrontend;
    private SparqlServiceFactory delegate;
    private Integer pageSize;

    public SparqlServiceFactoryImpl(CacheFrontend cacheFrontend) {
        this(new SparqlServiceFactoryHttp(), cacheFrontend, null);
    }

    public SparqlServiceFactoryImpl(CacheFrontend cacheFrontend, Integer pageSize) {
        this(new SparqlServiceFactoryHttp(), cacheFrontend, pageSize);
    }

    public SparqlServiceFactoryImpl(Integer pageSize) {
        this(new SparqlServiceFactoryHttp(), null, pageSize);
    }

    public SparqlServiceFactoryImpl(SparqlServiceFactory delegate, CacheFrontend cacheFrontend, Integer pageSize) {
        this.delegate = delegate;
        this.cacheFrontend = cacheFrontend;
        this.pageSize = pageSize;
    }

    @Override
    public SparqlService createSparqlService(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        if (datasetDescription == null) {
            datasetDescription = new DatasetDescription();
        }
        String str = DatasetDescriptionUtils.toString((DatasetDescription)datasetDescription);
        String key = serviceUri + str;
        SparqlService result = this.keyToSparqlService.get(key);
        if (result == null) {
            SparqlService tmp = this.delegate.createSparqlService(serviceUri, datasetDescription, httpClient);
            QueryExecutionFactory qef = tmp.getQueryExecutionFactory();
            if (this.cacheFrontend != null) {
                qef = new QueryExecutionFactoryCacheEx(qef, this.cacheFrontend);
            }
            if (this.pageSize != null && this.pageSize >= 0) {
                qef = new QueryExecutionFactoryPaginated(qef);
            }
            result = new SparqlServiceImpl(qef, tmp.getUpdateExecutionFactory());
            this.keyToSparqlService.put(key, result);
        }
        return result;
    }
}

