/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceImpl;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactoryHttp;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.stmt.SparqlParserConfig;
import org.aksw.jena_sparql_api.stmt.SparqlStmtParserImpl;
import org.aksw.jena_sparql_api.update.FluentSparqlService;
import org.apache.http.client.HttpClient;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class SparqlServiceUtils {
    public static SparqlService createSparqlServiceMem(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        DatasetGraph dg = DatasetGraphFactory.create();
        SparqlService result = (SparqlService)((FluentSparqlService)FluentSparqlService.from(dg).config().withParser(SparqlStmtParserImpl.create(SparqlParserConfig.create(Syntax.syntaxARQ))).withDatasetDescription(datasetDescription).end()).create();
        return result;
    }

    public static SparqlService createSparqlService(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        SparqlService result = serviceUri != null && serviceUri.startsWith("mem://") ? SparqlServiceUtils.createSparqlServiceMem(serviceUri, datasetDescription, httpClient) : SparqlServiceUtils.createSparqlServiceHttp(serviceUri, datasetDescription, httpClient);
        return result;
    }

    public static SparqlService createSparqlServiceHttp(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp(serviceUri, datasetDescription, httpClient);
        UpdateExecutionFactoryHttp uef = new UpdateExecutionFactoryHttp(serviceUri, datasetDescription, httpClient);
        SparqlServiceImpl result = new SparqlServiceImpl(serviceUri, datasetDescription, qef, uef);
        return result;
    }
}

