/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core;

import org.aksw.jena_sparql_api.core.UpdateExecutionFactoryParsingBase;
import org.aksw.jena_sparql_api.core.utils.UpdateRequestUtils;
import org.apache.http.client.HttpClient;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.modify.UpdateProcessRemote;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecutionFactoryHttp
extends UpdateExecutionFactoryParsingBase {
    private String remoteEndpoint;
    private HttpClient httpClient;
    private DatasetDescription datasetDescription;

    public UpdateExecutionFactoryHttp(String remoteEndpoint) {
        this(remoteEndpoint, null);
    }

    public UpdateExecutionFactoryHttp(String remoteEndpoint, HttpClient httpClient) {
        this(remoteEndpoint, new DatasetDescription(), httpClient);
    }

    public UpdateExecutionFactoryHttp(String remoteEndpoint, DatasetDescription datasetDescription, HttpClient httpClient) {
        this.remoteEndpoint = remoteEndpoint;
        this.datasetDescription = datasetDescription;
        this.httpClient = httpClient;
    }

    @Override
    public UpdateProcessor createUpdateProcessor(UpdateRequest updateRequest) {
        UpdateRequestUtils.fixVarNames(updateRequest);
        UpdateProcessRemote result = new UpdateProcessRemote(updateRequest, this.remoteEndpoint, null);
        result.setClient(this.httpClient);
        result.setDefaultGraphs(this.datasetDescription.getDefaultGraphURIs());
        result.setNamedGraphs(this.datasetDescription.getNamedGraphURIs());
        return result;
    }
}

