/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.utils.GeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.VarUtils;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;

public class QueryGenerationUtils {
    public static Query createQueryQuad(Quad quad) {
        Query query = new Query();
        query.setQuerySelectType();
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        s = g == null || g.equals((Object)Node.ANY) ? Vars.g : g;
        s = s == null || s.equals((Object)Node.ANY) ? Vars.s : s;
        p = p == null || p.equals((Object)Node.ANY) ? Vars.p : p;
        o = o == null || o.equals((Object)Node.ANY) ? Vars.o : o;
        Triple triple = new Triple(s, p, o);
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        ElementTriplesBlock element = new ElementTriplesBlock(bgp);
        element = new ElementNamedGraph(g, (Element)element);
        query.setQueryPattern((Element)element);
        return query;
    }

    public static Query createQueryTriple(Triple m) {
        Query query = new Query();
        query.setQueryConstructType();
        Node s = m.getSubject();
        Node p = m.getPredicate();
        Node o = m.getObject();
        s = s == null || s.equals((Object)Node.ANY) ? Vars.s : s;
        p = p == null || p.equals((Object)Node.ANY) ? Vars.p : p;
        o = o == null || o.equals((Object)Node.ANY) ? Vars.o : o;
        Triple triple = new Triple(s, p, o);
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        Template template = new Template(bgp);
        ElementTriplesBlock element = new ElementTriplesBlock(bgp);
        query.setConstructTemplate(template);
        query.setQueryPattern((Element)element);
        return query;
    }

    public static Query wrapAsSubQuery(Query query, Var v) {
        ElementSubQuery esq = new ElementSubQuery(query);
        Query result = new Query();
        result.setQuerySelectType();
        result.getProject().add(v);
        result.setQueryPattern((Element)esq);
        return result;
    }

    public static Concept createPredicateQuery(Concept concept) {
        Collection vars = PatternVars.vars((Element)concept.getElement());
        List varNames = VarUtils.getVarNames((Iterable)vars);
        Var s = concept.getVar();
        GeneratorBlacklist gen = GeneratorBlacklist.create((String)"v", (Collection)varNames);
        Var p = Var.alloc((String)gen.next());
        Var o = Var.alloc((String)gen.next());
        Triple triple = new Triple((Node)s, (Node)p, (Node)o);
        BasicPattern bp = new BasicPattern();
        bp.add(triple);
        List<Element> elements = concept.isSubjectConcept() ? new ArrayList<Element>() : concept.getElements();
        elements.add((Element)new ElementTriplesBlock(bp));
        Concept result = new Concept(elements, p);
        return result;
    }
}

