/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.ConceptUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.ResultSetUtils;
import org.aksw.jena_sparql_api.lookup.CountInfo;
import org.aksw.jena_sparql_api.utils.CloseableQueryExecution;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.core.Var;

public class ServiceUtils {
    public static List<Resource> fetchListResources(QueryExecutionFactory qef, Concept concept) {
        List<Node> tmp = ServiceUtils.fetchList(qef, concept);
        ArrayList<Resource> result = new ArrayList<Resource>(tmp.size());
        for (Node node : tmp) {
            Resource resource = ResourceFactory.createResource((String)node.getURI());
            result.add(resource);
        }
        return result;
    }

    public static List<Node> fetchList(QueryExecutionFactory qef, Concept concept, Long limit, Long offset) {
        Query query = ConceptUtils.createQueryList(concept, limit, offset);
        List<Node> result = ServiceUtils.fetchList(qef, query, concept.getVar());
        return result;
    }

    public static List<Node> fetchList(QueryExecutionFactory qef, Concept concept) {
        Query query = ConceptUtils.createQueryList(concept);
        List<Node> result = ServiceUtils.fetchList(qef, query, concept.getVar());
        return result;
    }

    public static List<Node> fetchList(QueryExecutionFactory qef, Query query, Var v) {
        QueryExecution qe = qef.createQueryExecution(query);
        List<Node> result = ServiceUtils.fetchList(qe, v);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Node> fetchList(QueryExecution qe, Var v) {
        try {
            List result;
            ResultSet rs = qe.execSelect();
            List list = result = org.aksw.jena_sparql_api.utils.ResultSetUtils.resultSetToList((ResultSet)rs, (Var)v);
            return list;
        }
        finally {
            qe.close();
        }
    }

    public static Integer fetchInteger(QueryExecutionFactory qef, Query query, Var v) {
        QueryExecution qe = qef.createQueryExecution(query);
        Integer result = ServiceUtils.fetchInteger(qe, v);
        return result;
    }

    public static Integer fetchInteger(QueryExecution qe, Var v) {
        ResultSet rs = qe.execSelect();
        Integer result = org.aksw.jena_sparql_api.utils.ResultSetUtils.resultSetToInt((ResultSet)rs, (Var)v);
        return result;
    }

    public static CountInfo fetchCountConcept(QueryExecutionFactory sparqlService, Concept concept, Long itemLimit, Long rowLimit) {
        Var outputVar = ConceptUtils.freshVar(concept);
        long xitemLimit = itemLimit == null ? null : Long.valueOf(itemLimit + 1L);
        long xrowLimit = rowLimit == null ? null : Long.valueOf(rowLimit + 1L);
        Query countQuery = ConceptUtils.createQueryCount(concept, outputVar, xitemLimit, xrowLimit);
        Integer count = ServiceUtils.fetchInteger(sparqlService, countQuery, outputVar);
        boolean hasMoreItems = rowLimit != null ? null : Boolean.valueOf(itemLimit != null ? (long)count.intValue() > itemLimit : false);
        Long c = hasMoreItems ? itemLimit : (long)count.intValue();
        CountInfo result = new CountInfo(c, hasMoreItems, itemLimit);
        return result;
    }

    public static ResultSet forceExecResultSet(QueryExecution qe, Query query) {
        ResultSet result;
        if (query.isSelectType()) {
            result = qe.execSelect();
        } else if (query.isConstructType()) {
            Iterator it = qe.execConstructTriples();
            result = ResultSetUtils.tripleIteratorToResultSet(it, (Closeable)new CloseableQueryExecution(qe));
        } else {
            throw new RuntimeException("Query type is not supported: " + query);
        }
        return result;
    }
}

