/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.core.QuadContainmentChecker;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.FN_DiffFromBindings;
import org.aksw.jena_sparql_api.utils.DatasetGraphDiffUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.jena_sparql_api.utils.QueryUtils;
import org.aksw.jena_sparql_api.utils.ResultSetUtils;
import org.aksw.jena_sparql_api.utils.SetDatasetGraph;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.update.Update;
import org.apache.jena.util.iterator.ExtendedIterator;

public class UpdateDiffUtils {
    public static Diff<DatasetGraph> combineDatasetGraph(Iterable<? extends Diff<? extends DatasetGraph>> diffs) {
        Diff result = Diff.create((Object)DatasetGraphFactory.createMem(), (Object)DatasetGraphFactory.createMem());
        Diff resultView = DatasetGraphDiffUtils.wrapDatasetGraph((Diff)result);
        for (Diff<? extends DatasetGraph> diff : diffs) {
            Diff itemView = DatasetGraphDiffUtils.wrapDatasetGraph(diff);
            UpdateDiffUtils.combine(resultView, itemView);
        }
        return result;
    }

    public static <T> void combine(Diff<? extends Collection<T>> target, Diff<? extends Iterable<T>> source) {
        Iterables.addAll((Collection)((Collection)target.getAdded()), (Iterable)((Iterable)source.getAdded()));
        Iterables.addAll((Collection)((Collection)target.getRemoved()), (Iterable)((Iterable)source.getRemoved()));
    }

    public static Diff<Set<Quad>> combineIterables(Iterable<? extends Diff<? extends Iterable<Quad>>> diffs) {
        Diff result = Diff.create(new HashSet(), new HashSet());
        for (Diff<? extends Iterable<Quad>> diff : diffs) {
            UpdateDiffUtils.combine(result, diff);
        }
        return result;
    }

    public static Diff<Set<Quad>> makeUnique(Diff<? extends Iterable<Quad>> diff, QueryExecutionFactory qef, QuadContainmentChecker quadContainmentChecker) {
        Set added = SetUtils.asSet((Iterable)((Iterable)diff.getAdded()));
        Set removed = SetUtils.asSet((Iterable)((Iterable)diff.getRemoved()));
        added = added == null ? Collections.emptySet() : added;
        removed = removed == null ? Collections.emptySet() : removed;
        HashSet<Quad> toCheck = new HashSet<Quad>();
        toCheck.addAll(added);
        toCheck.addAll(removed);
        Set<Quad> containedQuads = quadContainmentChecker.contains(qef, toCheck);
        Sets.SetView actualAdded = Sets.difference((Set)added, containedQuads);
        Sets.SetView actualRemoved = Sets.intersection((Set)removed, containedQuads);
        Diff result = new Diff((Object)actualAdded, (Object)actualRemoved, null);
        return result;
    }

    public static Iterator<Diff<Set<Quad>>> createIteratorDiff(QueryExecutionFactory qef, Update update, int batchSize) {
        Iterator<Diff<Set<Quad>>> result;
        if (update instanceof UpdateModify) {
            result = UpdateDiffUtils.createIteratorDiff(qef, (UpdateModify)update, batchSize);
        } else if (update instanceof UpdateDataInsert) {
            result = UpdateDiffUtils.createIteratorDiff(qef, (UpdateDataInsert)update);
        } else if (update instanceof UpdateDataDelete) {
            result = UpdateDiffUtils.createIteratorDiff(qef, (UpdateDataDelete)update);
        } else if (update instanceof UpdateDeleteWhere) {
            result = UpdateDiffUtils.createIteratorDiff(qef, (UpdateDeleteWhere)update, batchSize);
        } else {
            throw new RuntimeException("Unsupported update type: " + update.getClass());
        }
        return result;
    }

    public static Iterator<Diff<Set<Quad>>> createIteratorDiff(QueryExecutionFactory qef, UpdateDeleteWhere update, int batchSize) {
        UpdateModify tmp = new UpdateModify();
        QuadAcc acc = tmp.getDeleteAcc();
        for (Quad quad : update.getQuads()) {
            acc.addQuad(quad);
        }
        Element element = QuadUtils.toElement((Iterable)acc.getQuads());
        tmp.setElement(element);
        Iterator<Diff<Set<Quad>>> result = UpdateDiffUtils.createIteratorDiff(qef, tmp, batchSize);
        return result;
    }

    public static Iterator<Diff<Set<Quad>>> createIteratorDiff(QueryExecutionFactory qef, UpdateModify update, int batchSize) {
        Element wherePattern = update.getWherePattern();
        Query query = QueryUtils.elementToQuery((Element)wherePattern);
        QueryExecution qe = qef.createQueryExecution(query);
        ExtendedIterator itBinding = ResultSetUtils.toIteratorBinding((QueryExecution)qe);
        UnmodifiableIterator itBindingChunk = Iterators.partition((Iterator)itBinding, (int)batchSize);
        Diff template = new Diff((Object)update.getInsertQuads(), (Object)update.getDeleteQuads(), null);
        Iterator<Diff<Set<Quad>>> result = UpdateDiffUtils.createIteratorDiff((Iterator<? extends Iterable<? extends Binding>>)itBindingChunk, (Diff<? extends Iterable<Quad>>)template);
        return result;
    }

    public static Iterator<Diff<Set<Quad>>> createIteratorDiff(QueryExecutionFactory qef, UpdateDataInsert update) {
        Diff diff = new Diff((Object)Sets.newHashSet((Iterable)update.getQuads()), (Object)Sets.newHashSet(), null);
        Iterator<Diff<Set<Quad>>> result = Collections.singleton(diff).iterator();
        return result;
    }

    public static Iterator<Diff<Set<Quad>>> createIteratorDiff(QueryExecutionFactory qef, UpdateDataDelete update) {
        Diff diff = new Diff((Object)Sets.newHashSet(), (Object)Sets.newHashSet((Iterable)update.getQuads()), null);
        Iterator<Diff<Set<Quad>>> result = Collections.singleton(diff).iterator();
        return result;
    }

    public static Iterator<Diff<Set<Quad>>> createIteratorDiff(Iterator<? extends Iterable<? extends Binding>> itBindings, Diff<? extends Iterable<Quad>> quadDiff) {
        FN_DiffFromBindings fn = FN_DiffFromBindings.create(quadDiff);
        Iterator result = Iterators.transform(itBindings, (Function)fn);
        return result;
    }

    public static Diff<Set<Quad>> buildDiff(Iterable<? extends Binding> bindings, Diff<? extends Iterable<Quad>> quadDiff) {
        HashSet inserts = new HashSet();
        HashSet deletes = new HashSet();
        for (Binding binding : bindings) {
            Set i = QueryUtils.instanciate((Iterable)((Iterable)quadDiff.getAdded()), (Binding)binding);
            Set d = QueryUtils.instanciate((Iterable)((Iterable)quadDiff.getRemoved()), (Binding)binding);
            inserts.addAll(i);
            deletes.addAll(d);
        }
        Diff result = new Diff(inserts, deletes, null);
        return result;
    }

    public static Diff<Set<Quad>> computeDelta(DatasetGraph after, DatasetGraph before) {
        SetDatasetGraph afterSet = new SetDatasetGraph(after);
        SetDatasetGraph beforeSet = new SetDatasetGraph(before);
        Diff<Set<Quad>> result = UpdateDiffUtils.computeDelta((Set<Quad>)afterSet, (Set<Quad>)beforeSet);
        return result;
    }

    public static Diff<Set<Quad>> computeDelta(Set<Quad> after, Set<Quad> before) {
        Sets.SetView actualAdded = Sets.difference(after, before);
        Sets.SetView actualRemoved = Sets.difference(before, after);
        Diff result = new Diff((Object)actualAdded, (Object)actualRemoved, null);
        return result;
    }
}

