/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.core.DatasetListener;
import org.aksw.jena_sparql_api.core.QuadContainmentChecker;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.UpdateContext;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.DatasetListenerUtils;
import org.aksw.jena_sparql_api.core.utils.FN_QuadDiffUnique;
import org.aksw.jena_sparql_api.core.utils.FN_QuadFromTriple;
import org.aksw.jena_sparql_api.core.utils.UpdateDiffUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateRequestUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateUtils;
import org.aksw.jena_sparql_api.http.HttpExceptionUtils;
import org.aksw.jena_sparql_api.utils.DatasetDescriptionUtils;
import org.aksw.jena_sparql_api.utils.DatasetGraphDiffUtils;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.NodeUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.modify.request.UpdateDeleteInsert;
import org.apache.jena.update.GraphStoreFactory;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateExecutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(UpdateExecutionUtils.class);

    public static void copyByConstruct(SparqlService target, SparqlService source, String constructQueryStr, int batchSize) {
        Query query = QueryFactory.create((String)constructQueryStr, (String)"http://example.org/", (Syntax)Syntax.syntaxARQ);
        QueryExecution qe = source.getQueryExecutionFactory().createQueryExecution(query);
        Iterator it = qe.execConstructTriples();
        UnmodifiableIterator itPart = Iterators.partition((Iterator)it, (int)batchSize);
        while (itPart.hasNext()) {
            List part = (List)itPart.next();
            logger.debug("Items in this chunk: " + part.size());
            UpdateExecutionUtils.executeInsertTriples(target.getUpdateExecutionFactory(), part);
        }
        logger.debug("Done with this chunk");
    }

    public static UpdateProcessor executeInsert(UpdateExecutionFactory uef, Model model) {
        Graph graph = model.getGraph();
        UpdateProcessor result = UpdateExecutionUtils.executeInsert(uef, graph);
        return result;
    }

    public static UpdateProcessor executeInsert(UpdateExecutionFactory uef, Graph graph) {
        Set triples = graph.find(null, null, null).toSet();
        UpdateProcessor result = UpdateExecutionUtils.executeInsertTriples(uef, triples);
        return result;
    }

    public static void executeUpdate(SparqlService sparqlService, String requestStr, int batchSize, QuadContainmentChecker containmentChecker, Iterable<DatasetListener> listeners) {
        UpdateRequest updateRequest = UpdateRequestUtils.parse(requestStr);
        UpdateExecutionUtils.executeUpdate(sparqlService, updateRequest, batchSize, containmentChecker, listeners);
    }

    public static void executeUpdate(SparqlService sparqlService, UpdateRequest request, int batchSize, QuadContainmentChecker containmentChecker, Iterable<DatasetListener> listeners) {
        QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
        FN_QuadDiffUnique filter = new FN_QuadDiffUnique(qef, containmentChecker);
        for (Update update : request.getOperations()) {
            UpdateExecutionUtils.executeUpdateCore(sparqlService, update, filter, batchSize, listeners);
        }
    }

    public static String extractWithIri(SparqlService sparqlService, Update update) {
        String result = UpdateUtils.getWithIri(update);
        if (result == null) {
            DatasetDescription datasetDescription = sparqlService.getDatasetDescription();
            result = DatasetDescriptionUtils.getSingleDefaultGraphUri((DatasetDescription)datasetDescription);
        }
        return result;
    }

    public static void executeUpdateCore(SparqlService sparqlService, Update update, Function<Diff<? extends Iterable<Quad>>, Diff<Set<Quad>>> filter, int batchSize, Iterable<DatasetListener> listeners) {
        QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
        UpdateExecutionFactory uef = sparqlService.getUpdateExecutionFactory();
        Node with = NodeUtils.asNullableNode((String)UpdateExecutionUtils.extractWithIri(sparqlService, update));
        if (with == null) {
            throw new RuntimeException("No target graph for updates could be identified; i.e. no with uri or single default graph specified. " + update);
        }
        Iterator<Diff<Set<Quad>>> itDiffRaw = UpdateDiffUtils.createIteratorDiff(qef, update, batchSize);
        HashMap<Node, Node> map = new HashMap<Node, Node>();
        map.put(Quad.defaultGraphIRI, with);
        map.put(Quad.defaultGraphNodeGenerated, with);
        NodeTransformRenameMap nodeTransform = new NodeTransformRenameMap(map);
        Iterator itDiff = Iterators.transform(itDiffRaw, (Function)new Function<Diff<Set<Quad>>, Diff<Set<Quad>>>((NodeTransform)nodeTransform){
            final /* synthetic */ NodeTransform val$nodeTransform;
            {
                this.val$nodeTransform = nodeTransform;
            }

            public Diff<Set<Quad>> apply(Diff<Set<Quad>> input) {
                Set added = QuadUtils.applyNodeTransform((Set)((Set)input.getAdded()), (NodeTransform)this.val$nodeTransform);
                Set removed = QuadUtils.applyNodeTransform((Set)((Set)input.getRemoved()), (NodeTransform)this.val$nodeTransform);
                Diff r = Diff.create((Object)added, (Object)removed);
                return r;
            }
        });
        while (itDiff.hasNext()) {
            Diff filteredDiff;
            Diff diff = (Diff)itDiff.next();
            Diff diff2 = filteredDiff = filter != null ? (Diff)filter.apply((Object)diff) : diff;
            if (listeners != null) {
                UpdateContext updateContext = new UpdateContext(sparqlService, batchSize, null);
                DatasetListenerUtils.notifyListeners(listeners, (Diff<Set<Quad>>)filteredDiff, updateContext);
            }
            UpdateExecutionUtils.executeUpdate(uef, (Diff<? extends Iterable<? extends Quad>>)diff);
        }
    }

    public static UpdateProcessor executeInsertTriples(UpdateExecutionFactory uef, Iterable<Triple> triples) {
        Iterable quads = Iterables.transform(triples, (Function)FN_QuadFromTriple.fnDefaultGraphNodeGenerated);
        UpdateProcessor result = UpdateExecutionUtils.executeInsertQuads(uef, quads);
        return result;
    }

    public static UpdateProcessor executeDeleteTriples(UpdateExecutionFactory uef, Iterable<Triple> triples) {
        Iterable quads = Iterables.transform(triples, (Function)FN_QuadFromTriple.fnDefaultGraphNodeGenerated);
        UpdateProcessor result = UpdateExecutionUtils.executeDeleteQuads(uef, quads);
        return result;
    }

    public static UpdateProcessor executeUpdateQuads(UpdateExecutionFactory uef, Iterable<? extends Quad> quads, boolean isDelete) {
        UpdateProcessor result = isDelete ? UpdateExecutionUtils.executeDeleteQuads(uef, quads) : UpdateExecutionUtils.executeInsertQuads(uef, quads);
        return result;
    }

    public static UpdateProcessor executeInsertQuads(UpdateExecutionFactory uef, Iterable<? extends Quad> quads) {
        UpdateRequest updateRequest = UpdateRequestUtils.createUpdateRequest(quads, Collections.emptySet());
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }

    public static UpdateProcessor executeDeleteQuads(UpdateExecutionFactory uef, Iterable<? extends Quad> quads) {
        UpdateRequest updateRequest = UpdateRequestUtils.createUpdateRequest(Collections.emptySet(), quads);
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }

    public static UpdateProcessor executeUpdate(UpdateExecutionFactory uef, Diff<? extends Iterable<? extends Quad>> diff) {
        UpdateRequest updateRequest = UpdateRequestUtils.createUpdateRequest(diff);
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }

    public static UpdateProcessor executeUpdateDatasetGraph(UpdateExecutionFactory uef, Diff<? extends DatasetGraph> diff) {
        Diff d = DatasetGraphDiffUtils.wrapDatasetGraph(diff);
        UpdateRequest updateRequest = UpdateRequestUtils.createUpdateRequest((Diff<? extends Iterable<? extends Quad>>)d);
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }

    public static UpdateProcessor executeUnlessEmpty(UpdateExecutionFactory uef, UpdateRequest updateRequest) {
        UpdateProcessor result;
        if (updateRequest.getOperations().isEmpty()) {
            UpdateRequest update = UpdateFactory.create((String)"PREFIX ex: <http://example.org/> INSERT { ex:_s ex:_p ex:_o } WHERE { ex:_s ex:_p ex:_o }");
            result = org.apache.jena.update.UpdateExecutionFactory.create((UpdateRequest)update, (DatasetGraph)GraphStoreFactory.create((Model)ModelFactory.createDefaultModel()));
            result.execute();
        } else {
            result = uef.createUpdateProcessor(updateRequest);
            try {
                result.execute();
            }
            catch (Exception e) {
                RuntimeException f = HttpExceptionUtils.makeHumanFriendly(e);
                throw f;
            }
        }
        return result;
    }

    public static UpdateProcessor executeUpdateDelta(UpdateExecutionFactory uef, DatasetGraph after, DatasetGraph before) {
        Diff<Set<Quad>> diff = UpdateDiffUtils.computeDelta(after, before);
        UpdateProcessor result = UpdateExecutionUtils.executeUpdate(uef, diff);
        return result;
    }

    public static UpdateDeleteInsert createUpdateRename(Node before, Node after, int i) {
        return null;
    }

    public static UpdateRequest createUpdateRequestRename(Node before, Node after) {
        UpdateRequest result = new UpdateRequest();
        UpdateDeleteInsert g = UpdateExecutionUtils.createUpdateRename(before, after, 0);
        UpdateDeleteInsert s = UpdateExecutionUtils.createUpdateRename(before, after, 1);
        UpdateDeleteInsert p = UpdateExecutionUtils.createUpdateRename(before, after, 2);
        UpdateDeleteInsert o = UpdateExecutionUtils.createUpdateRename(before, after, 3);
        result.add((Update)g);
        result.add((Update)s);
        result.add((Update)p);
        result.add((Update)o);
        return result;
    }

    public static UpdateProcessor executeUpdateRename(UpdateExecutionFactory uef, Node before, Node after) {
        UpdateRequest updateRequest = UpdateExecutionUtils.createUpdateRequestRename(before, after);
        UpdateProcessor result = UpdateExecutionUtils.executeUnlessEmpty(uef, updateRequest);
        return result;
    }
}

