/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.core.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.core.utils.FN_QuadFromTriple;
import org.aksw.jena_sparql_api.core.utils.UpdateUtils;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.SetGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteInsert;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class UpdateRequestUtils {
    public static UpdateRequest clone(UpdateRequest request) {
        UpdateRequest result = new UpdateRequest();
        result.setBaseURI(request.getBaseURI());
        result.setPrefixMapping(request.getPrefixMapping());
        result.setResolver(request.getResolver());
        for (Update update : request.getOperations()) {
            Update clone = UpdateUtils.clone(update);
            result.add(clone);
        }
        return result;
    }

    public static void applyWithIri(UpdateRequest updateRequest, String withIri) {
        for (Update update : updateRequest.getOperations()) {
            UpdateUtils.applyWithIriIfApplicable(update, withIri);
        }
    }

    public static void applyDatasetDescription(UpdateRequest updateRequest, DatasetDescription dg) {
        for (Update update : updateRequest.getOperations()) {
            UpdateUtils.applyDatasetDescriptionIfApplicable(update, dg);
        }
    }

    public static void fixVarNames(UpdateRequest updateRequest) {
        List updates = updateRequest.getOperations();
        for (Update update : updates) {
            Element after;
            Element before;
            UpdateDeleteInsert x;
            if (update instanceof UpdateDeleteInsert) {
                x = (UpdateDeleteInsert)update;
                before = x.getWherePattern();
                after = ElementUtils.fixVarNames((Element)before);
                x.setElement(after);
                continue;
            }
            if (!(update instanceof UpdateModify)) continue;
            x = (UpdateModify)update;
            before = x.getWherePattern();
            after = ElementUtils.fixVarNames((Element)before);
            x.setElement(after);
        }
    }

    public static UpdateRequest createUpdateRequestDatasetGraph(Diff<? extends DatasetGraph> diff) {
        Iterator a = ((DatasetGraph)diff.getAdded()).find();
        Iterator b = ((DatasetGraph)diff.getRemoved()).find();
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest(a, b);
        return result;
    }

    public static UpdateRequest createUpdateRequest(Diff<? extends Iterable<? extends Quad>> diff) {
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest((Iterable)diff.getAdded(), (Iterable)diff.getRemoved());
        return result;
    }

    public static UpdateRequest createUpdateRequest(Model added, Model removed) {
        SetGraph _a = added == null ? Collections.emptySet() : SetGraph.wrap((Graph)added.getGraph());
        SetGraph _r = removed == null ? Collections.emptySet() : SetGraph.wrap((Graph)removed.getGraph());
        Iterable a = Iterables.transform((Iterable)_a, (Function)FN_QuadFromTriple.fnDefaultGraphNodeGenerated);
        Iterable r = Iterables.transform((Iterable)_r, (Function)FN_QuadFromTriple.fnDefaultGraphNodeGenerated);
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest(a, r);
        return result;
    }

    public static UpdateRequest createUpdateRequest(Iterable<? extends Quad> added, Iterable<? extends Quad> removed) {
        Iterator<? extends Quad> a = added.iterator();
        Iterator<? extends Quad> b = removed.iterator();
        UpdateRequest result = UpdateRequestUtils.createUpdateRequest(a, b);
        return result;
    }

    public static UpdateRequest createUpdateRequest(Iterator<? extends Quad> added, Iterator<? extends Quad> removed) {
        UpdateRequest result = new UpdateRequest();
        if (added != null && added.hasNext()) {
            QuadDataAcc insertQuads = new QuadDataAcc((List)Lists.newArrayList(added));
            UpdateDataInsert insertData = new UpdateDataInsert(insertQuads);
            result.add((Update)insertData);
        }
        if (removed != null && removed.hasNext()) {
            QuadDataAcc deleteQuads = new QuadDataAcc((List)Lists.newArrayList(removed));
            UpdateDataDelete deleteData = new UpdateDataDelete(deleteQuads);
            result.add((Update)deleteData);
        }
        return result;
    }

    public static UpdateRequest parse(String requestStr) {
        UpdateRequest result = new UpdateRequest();
        UpdateFactory.parse((UpdateRequest)result, (String)requestStr);
        return result;
    }
}

