/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBase;
import org.aksw.jena_sparql_api.http.QueryExecutionHttpWrapper;
import org.aksw.jena_sparql_api.utils.DatasetDescriptionUtils;
import org.apache.http.client.HttpClient;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;

public class QueryExecutionFactoryHttp
extends QueryExecutionFactoryBase {
    private String service;
    private DatasetDescription datasetDescription;
    private HttpClient httpClient;

    public QueryExecutionFactoryHttp(String service) {
        this(service, Collections.emptySet());
    }

    public QueryExecutionFactoryHttp(String service, String defaultGraphName) {
        this(service, defaultGraphName == null ? Collections.emptySet() : Collections.singleton(defaultGraphName));
    }

    public QueryExecutionFactoryHttp(String service, Collection<String> defaultGraphs) {
        this(service, new DatasetDescription(new ArrayList<String>(defaultGraphs), Collections.emptyList()), null);
    }

    public QueryExecutionFactoryHttp(String service, DatasetDescription datasetDescription, HttpClient httpClient) {
        this.service = service;
        this.datasetDescription = datasetDescription;
        this.httpClient = httpClient;
    }

    @Override
    public String getId() {
        return this.service;
    }

    @Override
    public String getState() {
        String result = DatasetDescriptionUtils.toString((DatasetDescription)this.datasetDescription);
        return result;
    }

    public QueryExecution postProcesss(QueryEngineHTTP qe) {
        qe.setDefaultGraphURIs(this.datasetDescription.getDefaultGraphURIs());
        qe.setNamedGraphURIs(this.datasetDescription.getNamedGraphURIs());
        QueryExecutionHttpWrapper result = new QueryExecutionHttpWrapper((QueryExecution)qe);
        return result;
    }

    @Override
    public QueryExecution createQueryExecution(String queryString) {
        QueryEngineHTTP qe = new QueryEngineHTTP(this.service, queryString, this.httpClient);
        QueryExecution result = this.postProcesss(qe);
        return result;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        QueryEngineHTTP qe = new QueryEngineHTTP(this.service, query, this.httpClient);
        QueryExecution result = this.postProcesss(qe);
        return result;
    }
}

