/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.http;

import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.Iterator;
import org.aksw.jena_sparql_api.core.QueryExecutionDecorator;
import org.aksw.jena_sparql_api.http.HttpExceptionUtils;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.resultset.ResultSetException;

public class QueryExecutionHttpWrapper
extends QueryExecutionDecorator {
    public QueryExecutionHttpWrapper(QueryExecution decoratee) {
        super(decoratee);
    }

    @Override
    public ResultSet execSelect() {
        ResultSet result = QueryExecutionHttpWrapper.wrapException(new Supplier<ResultSet>(){

            public ResultSet get() {
                ResultSet r = QueryExecutionHttpWrapper.this.decoratee.execSelect();
                return r;
            }
        });
        return result;
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        Iterator<Triple> result = QueryExecutionHttpWrapper.wrapException(new Supplier<Iterator<Triple>>(){

            public Iterator<Triple> get() {
                Iterator r = QueryExecutionHttpWrapper.this.decoratee.execConstructTriples();
                return r;
            }
        });
        return result;
    }

    public static <T> T wrapException(Supplier<T> supplier) {
        Object result;
        try {
            result = supplier.get();
        }
        catch (Exception e) {
            RuntimeException f;
            if (e instanceof ResultSetException) {
                ResultSetException x = (ResultSetException)e;
                String msg = x.getMessage();
                if (msg.contains("One or more of the required keys")) {
                    ResultSet result2 = ResultSetFactory.create((QueryIterator)QueryIterNullIterator.create(null), Collections.emptyList());
                    return (T)result2;
                }
                f = new RuntimeException(e);
            } else {
                f = HttpExceptionUtils.makeHumanFriendly(e);
            }
            throw f;
        }
        return (T)result;
    }
}

