/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.limit;

import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryDecorator;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;

public class QueryExecutionFactoryLimit
extends QueryExecutionFactoryDecorator {
    private Long limit;
    private boolean doCloneQuery = false;

    public static <U extends QueryExecution> QueryExecutionFactoryLimit decorate(QueryExecutionFactory decoratee, boolean doCloneQuery, Long limit) {
        return new QueryExecutionFactoryLimit(decoratee, doCloneQuery, limit);
    }

    public QueryExecutionFactoryLimit(QueryExecutionFactory decoratee, boolean doCloneQuery, Long limit) {
        super(decoratee);
        this.limit = limit;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        if (this.limit != null) {
            if (query.getLimit() == Long.MIN_VALUE) {
                if (this.doCloneQuery) {
                    query = query.cloneQuery();
                }
                query.setLimit(this.limit.longValue());
            } else {
                long adjustedLimit = Math.min(this.limit, query.getLimit());
                if (adjustedLimit != query.getLimit()) {
                    if (this.doCloneQuery) {
                        query = query.cloneQuery();
                    }
                    query.setLimit(adjustedLimit);
                }
            }
        }
        return super.createQueryExecution(query);
    }

    @Override
    public QueryExecution createQueryExecution(String queryString) {
        Query query = QueryFactory.create((String)queryString);
        QueryExecution result = this.createQueryExecution(query);
        return result;
    }
}

