/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.ConceptUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.QueryExecutionUtils;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.lookup.CountInfo;
import org.aksw.jena_sparql_api.lookup.ListService;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.aggregate.AggCount;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementSubQuery;

public class ListServiceConcept
implements ListService<Concept, Node, Node> {
    private QueryExecutionFactory qef;

    public ListServiceConcept(QueryExecutionFactory qef) {
        this.qef = qef;
    }

    @Override
    public Map<Node, Node> fetchData(Concept concept, Long limit, Long offset) {
        Query query = concept.asQuery();
        query.setLimit(limit == null ? Long.MIN_VALUE : limit);
        query.setOffset(offset == null ? Long.MIN_VALUE : offset);
        List<Node> tmp = QueryExecutionUtils.executeList(this.qef, query, concept.getVar());
        LinkedHashMap<Node, Node> result = new LinkedHashMap<Node, Node>();
        for (Node node : tmp) {
            result.put(node, node);
        }
        return result;
    }

    public static Query createSubQuery(Query query, Var var) {
        ElementSubQuery esq = new ElementSubQuery(query);
        Query result = new Query();
        result.setQuerySelectType();
        result.getProject().add(var);
        result.setQueryPattern((Element)esq);
        return result;
    }

    public static Query createQueryCount(Concept concept, Long itemLimit, Long rowLimit, Var resultVar) {
        Query subQuery = concept.asQuery();
        if (rowLimit != null) {
            subQuery.setDistinct(false);
            subQuery.setLimit(rowLimit.longValue());
            subQuery = ListServiceConcept.createSubQuery(subQuery, concept.getVar());
            subQuery.setDistinct(true);
        }
        if (itemLimit != null) {
            subQuery.setLimit(itemLimit.longValue());
        }
        ElementSubQuery esq = new ElementSubQuery(subQuery);
        Query result = new Query();
        result.setQuerySelectType();
        result.getProject().add(resultVar, (Expr)new ExprAggregator(concept.getVar(), (Aggregator)new AggCount()));
        result.setQueryPattern((Element)esq);
        return result;
    }

    @Override
    public CountInfo fetchCount(Concept concept, Long itemLimit, Long rowLimit) {
        Var c = Var.alloc((String)"_c_");
        Long limit = itemLimit == null ? null : Long.valueOf(itemLimit + 1L);
        Query query = ListServiceConcept.createQueryCount(concept, limit, rowLimit, c);
        Node countNode = QueryExecutionUtils.executeSingle(this.qef, query, c);
        long count = ((Number)countNode.getLiteralValue()).longValue();
        boolean hasMoreItems = false;
        if (itemLimit != null && count > itemLimit) {
            count = itemLimit;
            hasMoreItems = true;
        }
        CountInfo result = new CountInfo(count, hasMoreItems, itemLimit);
        return result;
    }

    public static void main(String[] args) {
        QueryExecutionFactoryHttp qef = new QueryExecutionFactoryHttp("http://dbpedia.org/sparql");
        ListServiceConcept ls = new ListServiceConcept(qef);
        Concept concept = ConceptUtils.listAllPredicates;
        CountInfo countInfo = ls.fetchCount(concept, (Long)2L, (Long)null);
        System.out.println(countInfo);
        countInfo = ls.fetchCount(concept, (Long)3L, (Long)null);
        System.out.println(countInfo);
        countInfo = ls.fetchCount(concept, (Long)4L, (Long)null);
        System.out.println(countInfo);
        countInfo = ls.fetchCount(concept, (Long)null, (Long)null);
        System.out.println(countInfo);
        Map data = ls.fetchData(concept, (Long)null, (Long)null);
        System.out.println(data);
    }
}

