/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.base.Function;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.lookup.CountInfo;
import org.aksw.jena_sparql_api.lookup.ListService;

class ListServiceTransformItem<C, K, I, O>
implements ListService<C, K, O> {
    private ListService<C, K, I> listService;
    private Function<I, O> fnTransformItem;

    public ListServiceTransformItem(ListService<C, K, I> listService, Function<I, O> fnTransformItem) {
        this.listService = listService;
        this.fnTransformItem = fnTransformItem;
    }

    @Override
    public Map<K, O> fetchData(C concept, Long limit, Long offset) {
        Map<K, I> map = this.listService.fetchData(concept, limit, offset);
        LinkedHashMap<K, Object> result = new LinkedHashMap<K, Object>();
        for (Map.Entry<K, I> entry : map.entrySet()) {
            K k = entry.getKey();
            I i = entry.getValue();
            Object o = this.fnTransformItem.apply(i);
            result.put(k, o);
        }
        return result;
    }

    @Override
    public CountInfo fetchCount(C concept, Long itemLimit, Long rowLimit) {
        CountInfo result = this.listService.fetchCount(concept, itemLimit, rowLimit);
        return result;
    }

    public static <C, K, I, O> ListServiceTransformItem<C, K, I, O> create(ListService<C, K, I> listService, Function<I, O> fnTransformItem) {
        ListServiceTransformItem<C, K, I, O> result = new ListServiceTransformItem<C, K, I, O>(listService, fnTransformItem);
        return result;
    }
}

