/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import java.util.Set;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.ConceptUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.lookup.ListService;
import org.aksw.jena_sparql_api.lookup.ListServiceSparqlQuery;
import org.aksw.jena_sparql_api.lookup.ListServiceTransformItem;
import org.aksw.jena_sparql_api.mapper.Agg;
import org.aksw.jena_sparql_api.mapper.FunctionResultSetAggregate;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.mapper.MappedQuery;
import org.aksw.jena_sparql_api.mapper.PartitionedQuery1;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;

public class ListServiceUtils {
    public static <T> ListService<Concept, Node, T> createListServiceMappedQuery(QueryExecutionFactory qef, MappedQuery<T> mappedQuery, boolean isLeftJoin) {
        ListService<Concept, Node, T> result = ListServiceUtils.createListServiceAcc(qef, mappedQuery, isLeftJoin);
        return result;
    }

    public static <T> ListService<Concept, Node, T> createListServiceAcc(QueryExecutionFactory qef, MappedQuery<T> mappedQuery, boolean isLeftJoin) {
        PartitionedQuery1 partQuery = mappedQuery.getPartQuery();
        Query query = partQuery.getQuery();
        Var partVar = partQuery.getPartitionVar();
        Agg<T> agg = mappedQuery.getAgg();
        if (query.isSelectType()) {
            Set<Var> vars = agg.getDeclaredVars();
            if (vars == null) {
                query.setQueryResultStar(true);
            } else {
                for (Var var : vars) {
                    if (query.getProject().contains(var)) continue;
                    query.getProject().add(var);
                }
            }
        }
        ListServiceSparqlQuery ls = new ListServiceSparqlQuery(qef, query, partVar, isLeftJoin);
        FunctionResultSetAggregate<T> fn = new FunctionResultSetAggregate<T>(agg);
        ListServiceTransformItem result = ListServiceTransformItem.create(ls, fn);
        return result;
    }

    public static <T> ListService<Concept, Node, T> createListServiceAcc(QueryExecutionFactory qef, MappedConcept<T> mappedConcept, boolean isLeftJoin) {
        Concept concept = mappedConcept.getConcept();
        Query query = ConceptUtils.createQueryList(concept);
        Agg<T> agg = mappedConcept.getAggregator();
        Set<Var> vars = agg.getDeclaredVars();
        for (Var var : vars) {
            query.getProject().add(var);
        }
        ListServiceSparqlQuery ls = new ListServiceSparqlQuery(qef, query, concept.getVar(), isLeftJoin);
        FunctionResultSetAggregate<T> fn = new FunctionResultSetAggregate<T>(agg);
        ListServiceTransformItem result = ListServiceTransformItem.create(ls, fn);
        return result;
    }

    public static <T> ListService<Concept, Node, T> createListServiceMappedConcept(QueryExecutionFactory qef, MappedConcept<T> mappedConcept, boolean isLeftJoin) {
        ListService<Concept, Node, T> result = ListServiceUtils.createListServiceAcc(qef, mappedConcept, isLeftJoin);
        return result;
    }
}

