/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import java.util.Map;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.lookup.ListService;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;

public class LookupServiceListService<V>
implements LookupService<Node, V> {
    private ListService<Concept, Node, V> listService;

    public LookupServiceListService(ListService<Concept, Node, V> listService) {
        this.listService = listService;
    }

    @Override
    public Map<Node, V> apply(Iterable<Node> nodes) {
        ExprList args = new ExprList();
        for (Node node : nodes) {
            NodeValue expr = NodeValue.makeNode((Node)node);
            args.add((Expr)expr);
        }
        E_OneOf e = new E_OneOf((Expr)new ExprVar(Vars.s), args);
        ElementFilter filter = new ElementFilter((Expr)e);
        Concept concept = new Concept((Element)filter, Vars.s);
        Map<Node, V> result = this.listService.fetchData(concept, null, null);
        return result;
    }

    public static <V> LookupServiceListService<V> create(ListService<Concept, Node, V> listService) {
        LookupServiceListService<V> result = new LookupServiceListService<V>(listService);
        return result;
    }
}

