/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupTask;

public class LookupServicePartition<K, V>
implements LookupService<K, V> {
    private LookupService<K, V> base;
    private int partitionSize;
    private int nThreads;

    public LookupServicePartition(LookupService<K, V> base, int partitionSize) {
        this(base, partitionSize, 1);
    }

    public LookupServicePartition(LookupService<K, V> base, int partitionSize, int nThreads) {
        this.base = base;
        this.partitionSize = partitionSize;
        this.nThreads = nThreads;
    }

    @Override
    public Map<K, V> apply(Iterable<K> keys) {
        try {
            Map<K, V> result = this.doLookup(keys);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<K, V> doLookup(Iterable<K> keys) throws InterruptedException, ExecutionException {
        int n;
        ExecutorCompletionService completionService;
        Iterable lists = Iterables.partition(keys, (int)this.partitionSize);
        ListeningExecutorService executorService = this.nThreads > 1 ? Executors.newFixedThreadPool(this.nThreads) : MoreExecutors.newDirectExecutorService();
        try {
            completionService = new ExecutorCompletionService((Executor)executorService);
            n = 0;
            for (List list : lists) {
                LookupTask<K, V> task = new LookupTask<K, V>(this.base, list);
                completionService.submit(task);
                ++n;
            }
        }
        finally {
            executorService.shutdown();
            executorService.awaitTermination(60L, TimeUnit.SECONDS);
        }
        HashMap result = new HashMap();
        for (int i = 0; i < n; ++i) {
            Future future = completionService.take();
            Map tmp = (Map)future.get();
            result.putAll(tmp);
        }
        return result;
    }

    public static <K, V> LookupServicePartition<K, V> create(LookupService<K, V> base, int partitionSize) {
        LookupServicePartition<K, V> result = new LookupServicePartition<K, V>(base, partitionSize);
        return result;
    }

    public static <K, V> LookupServicePartition<K, V> create(LookupService<K, V> base, int partitionSize, int nThreads) {
        LookupServicePartition<K, V> result = new LookupServicePartition<K, V>(base, partitionSize, nThreads);
        return result;
    }
}

