/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.ModelUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;

public class LookupServiceSparqlConstruct
implements LookupService<Node, Model> {
    private QueryExecutionFactory qef;
    private Query query;
    private Var var;

    public LookupServiceSparqlConstruct(QueryExecutionFactory qef, Query query, Var var) {
        this.qef = qef;
        this.query = query;
        this.var = var;
    }

    @Override
    public Map<Node, Model> apply(Iterable<Node> keys) {
        HashMap<Node, Model> result = new HashMap<Node, Model>();
        if (!Iterables.isEmpty(keys)) {
            ExprList exprs = new ExprList();
            for (Node key : keys) {
                NodeValue e = NodeValue.makeNode((Node)key);
                exprs.add((Expr)e);
            }
            E_OneOf expr = new E_OneOf((Expr)new ExprVar(this.var), exprs);
            ElementFilter filterElement = new ElementFilter((Expr)expr);
            Query q = this.query.cloneQuery();
            Element newElement = ElementUtils.mergeElements((Element)q.getQueryPattern(), (Element)filterElement);
            q.setQueryPattern(newElement);
            QueryExecution qe = this.qef.createQueryExecution(q);
            Model fullModel = qe.execConstruct();
            for (Node key : keys) {
                ResourceImpl s = new ResourceImpl(key, (ModelCom)fullModel);
                Model tmp = ModelUtils.filterBySubject((Model)fullModel, (Resource)s);
                result.put(key, tmp);
            }
        }
        return result;
    }
}

