/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.ExprListUtils;
import org.aksw.jena_sparql_api.utils.ResultSetPart;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;

public class LookupServiceSparqlQuery
implements LookupService<Node, ResultSetPart> {
    private QueryExecutionFactory sparqlService;
    private Query query;
    private Var var;

    public LookupServiceSparqlQuery(QueryExecutionFactory sparqlService, Query query, Var var) {
        this.sparqlService = sparqlService;
        this.query = query;
        this.var = var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Node, ResultSetPart> apply(Iterable<Node> keys) {
        HashMap<Node, ResultSetPart> result = new HashMap<Node, ResultSetPart>();
        if (!Iterables.isEmpty(keys)) {
            ExprList exprs = ExprListUtils.nodesToExprs(keys);
            E_OneOf expr = new E_OneOf((Expr)new ExprVar(this.var), exprs);
            ElementFilter filterElement = new ElementFilter((Expr)expr);
            System.out.println("Looking up: " + this.query);
            Query q = this.query.cloneQuery();
            Element newElement = ElementUtils.mergeElements((Element)q.getQueryPattern(), (Element)filterElement);
            q.setQueryPattern(newElement);
            HashMap<Node, ArrayList<Binding>> map = new HashMap<Node, ArrayList<Binding>>();
            try (QueryExecution qe = this.sparqlService.createQueryExecution(q);){
                ResultSet rs = qe.execSelect();
                ArrayList resultVars = new ArrayList(rs.getResultVars());
                while (rs.hasNext()) {
                    Binding binding = rs.nextBinding();
                    Node key = binding.get(this.var);
                    ArrayList<Binding> x = (ArrayList<Binding>)map.get(key);
                    if (x == null) {
                        x = new ArrayList<Binding>();
                        map.put(key, x);
                    }
                    x.add(binding);
                }
                for (Map.Entry entry : map.entrySet()) {
                    ResultSetPart rsp = new ResultSetPart(resultVars, (List)entry.getValue());
                    result.put((Node)entry.getKey(), rsp);
                }
            }
        }
        return result;
    }
}

