/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.base.Function;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.lookup.LookupService;

public class LookupServiceTransformKey<KI, KO, V>
implements LookupService<KI, V> {
    private LookupService<KO, V> delegate;
    private Function<KI, KO> keyMapper;

    public LookupServiceTransformKey(LookupService<KO, V> delegate, Function<KI, KO> keyMapper) {
        this.delegate = delegate;
        this.keyMapper = keyMapper;
    }

    @Override
    public Map<KI, V> apply(Iterable<KI> keys) {
        LinkedHashMap<Object, KI> keyMap = new LinkedHashMap<Object, KI>();
        for (KI ki : keys) {
            Object ko = this.keyMapper.apply(ki);
            keyMap.put(ko, ki);
        }
        Map tmp = (Map)this.delegate.apply(keyMap.keySet());
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : tmp.entrySet()) {
            Object ko = entry.getKey();
            Object v = entry.getValue();
            boolean isMapped = keyMap.containsKey(ko);
            if (!isMapped) {
                throw new RuntimeException("should not happen");
            }
            Object ki = keyMap.get(ko);
            result.put(ki, v);
        }
        return result;
    }

    public static <KI, KO, V> LookupServiceTransformKey<KI, KO, V> create(LookupService<KO, V> base, Function<KI, KO> keyMapper) {
        LookupServiceTransformKey<KI, KO, V> result = new LookupServiceTransformKey<KI, KO, V>(base, keyMapper);
        return result;
    }
}

