/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.lookup.LookupService;

public class LookupServiceTransformKey2<KI, KO, V>
implements LookupService<KI, V> {
    private LookupService<KO, V> delegate;
    private Function<? super KI, KO> to;
    private Function<? super Map.Entry<KO, V>, KI> from;

    public LookupServiceTransformKey2(LookupService<KO, V> delegate, Function<? super KI, KO> to, Function<? super Map.Entry<KO, V>, KI> from) {
        this.delegate = delegate;
        this.to = to;
        this.from = from;
    }

    @Override
    public Map<KI, V> apply(Iterable<KI> keys) {
        Iterable kos = Iterables.transform(keys, this.to);
        Map tmp = (Map)this.delegate.apply(kos);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : tmp.entrySet()) {
            Object ki = this.from.apply(entry);
            Object v = entry.getValue();
            result.put(ki, v);
        }
        return result;
    }

    public static <KI, KO, V> LookupServiceTransformKey2<KI, KO, V> create(LookupService<KO, V> delegate, Function<? super KI, KO> to, Function<? super Map.Entry<KO, V>, KI> from) {
        LookupServiceTransformKey2<? super KI, KO, V> result = new LookupServiceTransformKey2<KI, KO, V>(delegate, to, from);
        return result;
    }
}

