/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.lookup;

import java.util.List;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.concepts.RelationUtils;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceSparqlQuery;
import org.aksw.jena_sparql_api.lookup.LookupServiceTransformValue;
import org.aksw.jena_sparql_api.mapper.Agg;
import org.aksw.jena_sparql_api.mapper.AggList;
import org.aksw.jena_sparql_api.mapper.AggLiteral;
import org.aksw.jena_sparql_api.mapper.BindingMapperProjectVar;
import org.aksw.jena_sparql_api.mapper.FunctionResultSetAggregate;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.mapper.MappedQuery;
import org.aksw.jena_sparql_api.mapper.PartitionedQuery1;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;

public class LookupServiceUtils {
    public static <T> LookupService<Node, List<Node>> createLookupService(QueryExecutionFactory qef, Relation relation) {
        Var sourceVar = relation.getSourceVar();
        AggList<Node> agg = AggList.create(AggLiteral.create(BindingMapperProjectVar.create(relation.getTargetVar())));
        Query query = RelationUtils.createQuery(relation);
        MappedQuery<Node> mappedQuery = MappedQuery.create(query, sourceVar, agg);
        LookupService<Node, Node> result = LookupServiceUtils.createLookupService(qef, mappedQuery);
        return result;
    }

    public static <T> LookupService<Node, T> createLookupService(QueryExecutionFactory sparqlService, MappedQuery<T> mappedQuery) {
        PartitionedQuery1 partQuery = mappedQuery.getPartQuery();
        Query query = partQuery.getQuery();
        Var partVar = partQuery.getPartitionVar();
        Agg<T> agg = mappedQuery.getAgg();
        LookupServiceSparqlQuery base = new LookupServiceSparqlQuery(sparqlService, query, partVar);
        FunctionResultSetAggregate<T> transform = FunctionResultSetAggregate.create(agg);
        LookupServiceTransformValue result = LookupServiceTransformValue.create(base, transform);
        return result;
    }

    public static <T> LookupService<Node, T> createLookupService(QueryExecutionFactory sparqlService, MappedConcept<T> mappedConcept) {
        Concept concept = mappedConcept.getConcept();
        Query query = concept.asQuery();
        query.setQueryResultStar(true);
        LookupServiceSparqlQuery base = new LookupServiceSparqlQuery(sparqlService, query, concept.getVar());
        FunctionResultSetAggregate<T> transform = FunctionResultSetAggregate.create(mappedConcept.getAggregator());
        LookupServiceTransformValue result = LookupServiceTransformValue.create(base, transform);
        return result;
    }
}

