/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import java.util.function.Function;
import org.aksw.jena_sparql_api.mapper.Accumulator;

public class AccBindingTransform<B, V, U>
implements Accumulator<B, V> {
    protected Function<? super B, U> transform;
    protected Accumulator<? super U, V> subAcc;

    public AccBindingTransform(Function<? super B, U> transform, Accumulator<? super U, V> subAcc) {
        this.transform = transform;
        this.subAcc = subAcc;
    }

    @Override
    public void accumulate(B binding) {
        U u = this.transform.apply(binding);
        this.subAcc.accumulate(u);
    }

    @Override
    public V getValue() {
        V result = this.subAcc.getValue();
        return result;
    }

    public static <B, V, U> Accumulator<B, V> create(Function<? super B, U> transform, Accumulator<? super U, V> subAcc) {
        AccBindingTransform<? super B, V, ? super U> result = new AccBindingTransform<B, V, U>(transform, subAcc);
        return result;
    }
}

