/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import java.util.function.Predicate;
import org.aksw.jena_sparql_api.mapper.Accumulator;

public class AccCondition<B, V>
implements Accumulator<B, V> {
    protected Predicate<B> predicate;
    protected Accumulator<B, V> subAcc;

    public AccCondition(Predicate<B> predicate, Accumulator<B, V> subAcc) {
        this.predicate = predicate;
        this.subAcc = subAcc;
    }

    @Override
    public void accumulate(B binding) {
        boolean accept = this.predicate.test(binding);
        if (accept) {
            this.subAcc.accumulate(binding);
        }
    }

    @Override
    public V getValue() {
        V result = this.subAcc.getValue();
        return result;
    }

    public static <B, V> Accumulator<B, V> create(Predicate<B> predicate, Accumulator<B, V> subAcc) {
        AccCondition<B, V> result = new AccCondition<B, V>(predicate, subAcc);
        return result;
    }
}

