/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aksw.jena_sparql_api.mapper.Accumulator;
import org.aksw.jena_sparql_api.mapper.Aggregator;

public class AccMap2<B, K, V, C extends Aggregator<B, V>>
implements Accumulator<B, Map<K, V>> {
    protected BiFunction<B, Long, K> mapper;
    protected C subAgg;
    protected Map<K, Accumulator<B, V>> state = new HashMap<K, Accumulator<B, V>>();

    public AccMap2(Function<B, K> mapper, C subAgg) {
        this((B binding, Long rowNum) -> mapper.apply(binding), subAgg);
    }

    public AccMap2(BiFunction<B, Long, K> mapper, C subAgg) {
        this.mapper = mapper;
        this.subAgg = subAgg;
    }

    @Override
    public void accumulate(B binding) {
        K k = this.mapper.apply(binding, -1L);
        Accumulator<B, Object> subAcc = this.state.get(k);
        if (subAcc == null) {
            subAcc = this.subAgg.createAccumulator();
            this.state.put(k, subAcc);
        }
        subAcc.accumulate(binding);
    }

    @Override
    public Map<K, V> getValue() {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, Accumulator<B, V>> entry : this.state.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue().getValue();
            result.put(k, v);
        }
        return result;
    }

    public static <B, K, V, C extends Aggregator<B, V>> AccMap2<B, K, V, C> create(Function<B, K> mapper, C subAgg) {
        BiFunction<Object, Long, Object> fn = (binding, rowNum) -> mapper.apply(binding);
        AccMap2<Object, Object, V, C> result = new AccMap2<Object, Object, V, C>(fn, subAgg);
        return result;
    }

    public static <B, K, V, C extends Aggregator<B, V>> AccMap2<B, K, V, C> create(BiFunction<B, Long, K> mapper, C subAgg) {
        AccMap2<B, K, V, C> result = new AccMap2<B, K, V, C>(mapper, subAgg);
        return result;
    }
}

