/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.aksw.jena_sparql_api.mapper.Accumulator;

public class AccStaticMultiplex<B, K, U, V>
implements Accumulator<B, Map<K, V>> {
    protected BiFunction<B, K, ? extends U> childBinding;
    protected Map<K, Accumulator<U, V>> keyToSubAcc;

    public AccStaticMultiplex(BiFunction<B, K, ? extends U> childBinding, Map<K, Accumulator<U, V>> keyToSubAcc) {
        this.childBinding = childBinding;
        this.keyToSubAcc = keyToSubAcc;
    }

    @Override
    public void accumulate(B binding) {
        for (Map.Entry<K, Accumulator<U, V>> e : this.keyToSubAcc.entrySet()) {
            K k = e.getKey();
            Accumulator<U, V> subAcc = e.getValue();
            U u = this.childBinding.apply(binding, k);
            subAcc.accumulate(u);
        }
    }

    @Override
    public Map<K, V> getValue() {
        HashMap<K, V> result = new HashMap<K, V>(this.keyToSubAcc.size());
        for (Map.Entry<K, Accumulator<U, V>> e : this.keyToSubAcc.entrySet()) {
            K k = e.getKey();
            Accumulator<U, V> subAcc = e.getValue();
            V v = subAcc.getValue();
            result.put(k, v);
        }
        return result;
    }

    public static <B, K, U, V> Accumulator<B, Map<K, V>> create(BiFunction<B, K, ? extends U> childBinding, Map<K, Accumulator<U, V>> keyToSubAcc) {
        AccStaticMultiplex<B, K, ? extends U, V> result = new AccStaticMultiplex<B, K, U, V>(childBinding, keyToSubAcc);
        return result;
    }
}

