/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.mapper.Acc;
import org.aksw.jena_sparql_api.mapper.AccMap;
import org.aksw.jena_sparql_api.mapper.Agg;
import org.aksw.jena_sparql_api.mapper.BindingMapper;
import org.aksw.jena_sparql_api.mapper.BindingMapperVarAware;
import org.apache.jena.sparql.core.Var;

public class AggMap<K, V>
implements Agg<Map<K, V>> {
    private BindingMapper<K> mapper;
    private Agg<V> subAgg;

    public AggMap(BindingMapper<K> mapper, Agg<V> subAgg) {
        this.mapper = mapper;
        this.subAgg = subAgg;
    }

    @Override
    public Acc<Map<K, V>> createAccumulator() {
        AccMap result = new AccMap(this.mapper, this.subAgg);
        return result;
    }

    @Override
    public Set<Var> getDeclaredVars() {
        Set<Var> a = this.mapper instanceof BindingMapperVarAware ? ((BindingMapperVarAware)this.mapper).getVarsMentioned() : null;
        Set<Var> b = this.subAgg.getDeclaredVars();
        Sets.SetView result = a == null || b == null ? null : Sets.union(a, b);
        return result;
    }

    public static <K, V> AggMap<K, V> create(BindingMapper<K> mapper, Agg<V> subAgg) {
        AggMap<K, V> result = new AggMap<K, V>(mapper, subAgg);
        return result;
    }
}

