/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import com.google.common.base.Function;
import org.aksw.jena_sparql_api.mapper.Accumulator;
import org.aksw.jena_sparql_api.mapper.Agg;
import org.aksw.jena_sparql_api.utils.ResultSetPart;
import org.apache.jena.sparql.engine.binding.Binding;

public class FunctionResultSetAggregate<T>
implements Function<ResultSetPart, T> {
    private Agg<T> agg;

    public FunctionResultSetAggregate(Agg<T> agg) {
        this.agg = agg;
    }

    public T apply(ResultSetPart rs) {
        Accumulator acc = this.agg.createAccumulator();
        for (Binding binding : rs.getBindings()) {
            acc.accumulate(binding);
        }
        Object result = acc.getValue();
        return result;
    }

    public static <T> FunctionResultSetAggregate<T> create(Agg<T> agg) {
        FunctionResultSetAggregate<T> result = new FunctionResultSetAggregate<T>(agg);
        return result;
    }
}

