/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import java.util.Set;
import org.aksw.jena_sparql_api.mapper.AggDatasetGraph;
import org.aksw.jena_sparql_api.mapper.MappedQuery;
import org.aksw.jena_sparql_api.mapper.PartitionedQuery1;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.syntax.Template;

public class MappedQueryUtils {
    public static MappedQuery<DatasetGraph> fromConstructQuery(Query query, Var partitionVar) {
        PartitionedQuery1 partQuery = new PartitionedQuery1(query, partitionVar);
        MappedQuery<DatasetGraph> result = MappedQueryUtils.fromConstructQuery(partQuery);
        return result;
    }

    public static MappedQuery<DatasetGraph> fromConstructQuery(PartitionedQuery1 partQuery) {
        Var partVar;
        AggDatasetGraph agg;
        Query query = partQuery.getQuery().cloneQuery();
        if (query.isConstructType()) {
            Template template = query.getConstructTemplate();
            QuadPattern qp = QuadPatternUtils.toQuadPattern((Node)Quad.defaultGraphNodeGenerated, (BasicPattern)template.getBGP());
            agg = AggDatasetGraph.create(qp);
            query.setQuerySelectType();
            query.setQueryResultStar(false);
            VarExprList project = query.getProject();
            project.getVars().clear();
            project.getExprs().clear();
            Set<Var> vars = agg.getDeclaredVars();
            partVar = partQuery.getPartitionVar();
            if (!vars.contains(partVar)) {
                project.add(partVar);
            }
            for (Var var : vars) {
                project.add(var);
            }
        } else {
            throw new RuntimeException("Only construct query supported right now");
        }
        PartitionedQuery1 pq = new PartitionedQuery1(query, partVar);
        MappedQuery<DatasetGraph> result = new MappedQuery<DatasetGraph>(pq, agg);
        return result;
    }
}

