/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;

public class PartitionedQueryUtils {
    public static List<Range<Long>> partition(long numberOfItems, int requestedGridSize, Long pageSize) {
        ArrayList<Range<Long>> result = new ArrayList<Range<Long>>();
        long min = 0L;
        long max = numberOfItems;
        long gridSize = pageSize == null ? (long)requestedGridSize : Math.min((long)requestedGridSize, (max + pageSize - 1L) / pageSize);
        long targetSize = (max - min) / gridSize + 1L;
        long start = min;
        long end = start + targetSize - 1L;
        while (start <= max) {
            if (end >= max) {
                end = max;
            }
            Range range = Range.closed((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end));
            result.add((Range<Long>)range);
            start += targetSize;
            end += targetSize;
        }
        return result;
    }
}

